/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.issue.index.indexers.impl.FieldIndexerUtil;
import com.atlassian.jira.issue.index.indexers.phrase.PhraseQuerySupportField;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class SortableTextCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private final CustomField field;
    private final String sortFieldPrefix;

    public SortableTextCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, String sortFieldPrefix) {
        super(fieldVisibilityManager, Assertions.notNull("field", customField));
        this.sortFieldPrefix = Assertions.notBlank("sortFieldPrefix", sortFieldPrefix);
        this.field = customField;
    }

    @Override
    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.ANALYZED, true);
    }

    @Override
    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NO, false);
    }

    private void addDocumentFields(Document doc, Issue issue, Field.Index fieldIndexType, boolean sortable) {
        Object value = this.field.getValue(issue);
        if (value != null) {
            doc.add((Fieldable)new Field(this.getDocumentFieldId(), (String)value, Field.Store.YES, fieldIndexType));
            doc.add((Fieldable)new Field(PhraseQuerySupportField.forIndexField(this.getDocumentFieldId()), (String)value, Field.Store.YES, fieldIndexType));
        }
        if (sortable) {
            String valueForSorting = FieldIndexerUtil.getValueForSorting((String)value);
            doc.add((Fieldable)new Field(this.sortFieldPrefix + this.getDocumentFieldId(), valueForSorting, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
    }
}

