/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.config.item;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.converters.ProjectConverter;
import com.atlassian.jira.issue.customfields.option.GenericImmutableOptions;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import java.util.ArrayList;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectOptionsConfigItem
implements FieldConfigItemType {
    private static final Logger log = LoggerFactory.getLogger(ProjectOptionsConfigItem.class);
    private final ProjectConverter projectConverter;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;

    public ProjectOptionsConfigItem(ProjectConverter projectConverter, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.projectConverter = projectConverter;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public String getDisplayName() {
        return "Project options";
    }

    @Override
    public String getDisplayNameKey() {
        return "admin.issuefields.customfields.config.project.options";
    }

    @Override
    public String getViewHtml(FieldConfig fieldConfig, FieldLayoutItem fieldLayoutItem) {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.issuefields.customfields.config.project.options.all");
    }

    @Override
    public String getObjectKey() {
        return "options";
    }

    @Override
    public Object getConfigurationObject(Issue issue, FieldConfig config) {
        try {
            ArrayList<GenericValue> originalList = new ArrayList<GenericValue>(this.permissionManager.getProjects(10, this.jiraAuthenticationContext.getLoggedInUser()));
            return new GenericImmutableOptions<GenericValue>(originalList, config);
        }
        catch (UnsupportedOperationException e) {
            log.error("Unable to retrieve projects. Likely to be an issue with SubvertedPermissionManager. Please restart to resolve the problem.", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getBaseEditUrl() {
        return null;
    }
}

