/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabPanelUtil {
    public static final int MAX_ISSUES_TO_DISPLAY = 50;
    public static final PagerFilter PAGER_FILTER = new PagerFilter(50);
    private static final Long NO_VOTES = 0L;

    public static Collection subSetCollection(Collection collection, int subset) {
        if (collection == null || collection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (subset >= 0 && subset <= collection.size()) {
            return new ArrayList(collection).subList(0, subset);
        }
        return collection;
    }

    public static void filterIssuesWithNoVotes(List issues) {
        if (issues != null) {
            Iterator iterator = issues.iterator();
            while (iterator.hasNext()) {
                Long votes = ((Issue)iterator.next()).getVotes();
                if (votes != null && !NO_VOTES.equals(votes)) continue;
                iterator.remove();
            }
        }
    }

    public static class PopularIssues {
        private static final Logger log = LoggerFactory.getLogger(PopularIssues.class);
        private final SearchProvider searchProvider;
        private final ConstantsManager constantsManager;

        public PopularIssues(SearchProvider searchProvider, ConstantsManager constantsManager) {
            this.searchProvider = searchProvider;
            this.constantsManager = constantsManager;
        }

        public List getIssues(BrowseContext context, boolean resolved) {
            Assertions.notNull("context", context);
            User searcher = context.getUser();
            ArrayList<Issue> issues = new ArrayList<Issue>();
            try {
                Query initialQuery = context.createQuery();
                JqlQueryBuilder builder = JqlQueryBuilder.newBuilder(initialQuery);
                JqlClauseBuilder whereBuilder = builder.where().defaultAnd();
                if (!resolved) {
                    whereBuilder.unresolved();
                } else {
                    ArrayList<String> resolutionIds = new ArrayList<String>();
                    for (Resolution resolution : this.constantsManager.getResolutionObjects()) {
                        resolutionIds.add(resolution.getId());
                    }
                    if (!resolutionIds.isEmpty()) {
                        whereBuilder.resolution().inStrings(resolutionIds);
                    }
                }
                builder.orderBy().clear().votes(SortOrder.DESC).priority(SortOrder.DESC).issueKey(SortOrder.ASC);
                issues.addAll(this.searchProvider.search(builder.buildQuery(), searcher, PAGER_FILTER).getIssues());
                TabPanelUtil.filterIssuesWithNoVotes(issues);
            }
            catch (SearchException e) {
                log.error("Error finding popular issues: " + e, (Throwable)e);
            }
            return issues;
        }
    }
}

