/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.ShareQueryFactory;
import com.atlassian.jira.sharing.type.ShareTypePermissionChecker;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.sharing.type.ShareTypeValidator;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Comparator;

public interface ShareType {
    public Name getType();

    public boolean isSingleton();

    public int getPriority();

    public ShareTypeRenderer getRenderer();

    public ShareTypeValidator getValidator();

    public ShareTypePermissionChecker getPermissionsChecker();

    public ShareQueryFactory<? extends ShareTypeSearchParameter> getQueryFactory();

    public Comparator<SharePermission> getComparator();

    public static final class Name {
        public static final Name GLOBAL = new Name("global");
        public static final Name PROJECT = new Name("project");
        public static final Name GROUP = new Name("group");
        private final String name;

        public Name(String name) {
            Assertions.notBlank("name", name);
            this.name = name;
        }

        public String get() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Name other = (Name)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return this.name;
        }
    }
}

