/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.fugue.Function2;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.base.Preconditions;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonRawValue;

public class EntityPropertyBean {
    @JsonProperty
    @JsonIgnore
    private String self;
    @JsonProperty
    private String key;
    @JsonProperty
    @JsonRawValue
    private String value;

    public EntityPropertyBean() {
    }

    public EntityPropertyBean(String key, String value, String self) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.value = (String)Preconditions.checkNotNull((Object)value);
        this.self = self;
    }

    public String getSelf() {
        return this.self;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "EntityPropertyBean{key='" + this.key + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public static Builder builder(JiraBaseUrls jiraBaseUrls, Function2<Long, String, String> entityIdToSelfFunction) {
        return new Builder(jiraBaseUrls, entityIdToSelfFunction);
    }

    public static String propertySelf(JiraBaseUrls urls, Long entityId, String propertyKey, Function2<Long, String, String> selfFunction) {
        return urls.restApi2BaseUrl() + (String)selfFunction.apply((Object)entityId, (Object)JiraUrlCodec.encode(propertyKey));
    }

    public static class Builder {
        private final JiraBaseUrls urls;
        private String key;
        private String value;
        private Function2<Long, String, String> entityIdToSelfFunction;

        public Builder(JiraBaseUrls jiraBaseUrls, Function2<Long, String, String> entityIdToSelfFunction) {
            this.urls = jiraBaseUrls;
            this.entityIdToSelfFunction = entityIdToSelfFunction;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public EntityPropertyBean build(Long entityId) {
            return new EntityPropertyBean((String)Preconditions.checkNotNull((Object)this.key), (String)Preconditions.checkNotNull((Object)this.value), this.buildSelf(entityId));
        }

        private String buildSelf(Long entityId) {
            return EntityPropertyBean.propertySelf(this.urls, entityId, this.key, this.entityIdToSelfFunction);
        }
    }
}

