/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

@PublicApi
public interface Avatar {
    public static final List<String> demotedSystemProjectAvatars = Lists.newArrayList((Object[])new String[]{"codegeist.png", "jm_black.png", "jm_brown.png", "jm_orange.png", "jm_red.png", "jm_white.png", "jm_yellow.png", "monster.png"});

    @Nonnull
    public Type getAvatarType();

    @Nonnull
    public String getFileName();

    @Nonnull
    public String getContentType();

    public Long getId();

    @Nonnull
    public String getOwner();

    public boolean isSystemAvatar();

    public static enum Size {
        NORMAL("small", 24),
        SMALL("xsmall", 16),
        MEDIUM("medium", 32),
        LARGE("large", 48, true),
        XLARGE("xlarge", 64),
        XXLARGE("xxlarge", 96),
        XXXLARGE("xxxlarge", 128),
        RETINA_XXLARGE("xxlarge@2x", 192),
        RETINA_XXXLARGE("xxxlarge@2x", 256);

        public static final Predicate<Size> LOW_RES;
        final String param;
        final Integer pixels;
        final boolean isDefault;
        private static final Size largest;
        private static final Size defaultSize;
        private static final List<Size> orderedSizes;
        private static final Map<String, Size> paramToSize;

        private static Map<String, Size> createParamToSizeMap() {
            ImmutableMap.Builder paramToSize = ImmutableMap.builder();
            for (Size size : Size.values()) {
                paramToSize.put((Object)size.getParam(), (Object)size);
            }
            return paramToSize.build();
        }

        private Size(String param, int pixels, boolean isDefault) {
            this.param = param;
            this.isDefault = isDefault;
            this.pixels = pixels;
        }

        private Size(String param, int pixels) {
            this(param, pixels, false);
        }

        public static Size largest() {
            return largest;
        }

        public static Size defaultSize() {
            return defaultSize;
        }

        public static Size biggerThan(int pixelValue) {
            Size theSize = null;
            for (Size aSize : Size.inPixelOrder()) {
                if (aSize.pixels < pixelValue) continue;
                theSize = aSize;
                break;
            }
            return theSize;
        }

        public static Size smallerThan(int pixelValue) {
            Size theSize = null;
            for (Size aSize : Lists.reverse(Size.inPixelOrder())) {
                if (aSize.pixels > pixelValue) continue;
                theSize = aSize;
                break;
            }
            return theSize;
        }

        static List<Size> inPixelOrder() {
            if (null != orderedSizes) {
                return orderedSizes;
            }
            List<Size> orderedSizes = Arrays.asList(Size.values());
            Collections.sort(orderedSizes, new Comparator<Size>(){

                @Override
                public int compare(Size o1, Size o2) {
                    if (o1.getPixels() == o2.getPixels()) {
                        return 0;
                    }
                    return o1.getPixels() < o2.getPixels() ? -1 : 1;
                }
            });
            return orderedSizes;
        }

        public int getPixels() {
            return this.pixels;
        }

        public String getParam() {
            return this.param;
        }

        public String toString() {
            return String.format("<Size [%s], %dx%dpx>", this.param, this.pixels, this.pixels);
        }

        public static Size getSizeFromParam(String param) {
            if (null == param || !paramToSize.containsKey(param)) {
                throw new NoSuchElementException(param);
            }
            return paramToSize.get(param);
        }

        public static Size approx(int size) {
            if (size >= largest.getPixels()) {
                return largest;
            }
            if (size <= orderedSizes.get(0).getPixels()) {
                return orderedSizes.get(0);
            }
            for (Size s : orderedSizes) {
                if (s.getPixels() < size) continue;
                return s;
            }
            return defaultSize;
        }

        static {
            LOW_RES = new Predicate<Size>(){

                public boolean apply(Size input) {
                    return input.getPixels() <= 48;
                }
            };
            Size maxValue = SMALL;
            Size defaultValue = SMALL;
            for (Size imageSize : Size.values()) {
                if (imageSize.isDefault) {
                    defaultValue = imageSize;
                }
                if (imageSize.pixels <= maxValue.pixels) continue;
                maxValue = imageSize;
            }
            largest = maxValue;
            defaultSize = defaultValue;
            orderedSizes = Size.inPixelOrder();
            paramToSize = Size.createParamToSizeMap();
        }
    }

    public static enum Type {
        PROJECT("project", "jira.avatar.default.id"),
        USER("user", "jira.avatar.user.default.id"),
        ISSUETYPE("issuetype", "jira.avatar.issuetype.default.id");

        private String name;
        private String defaultIdKey;
        private static final Map<String, Type> typesByName;

        private static ImmutableMap<String, Type> createNameToTypeMap() {
            ImmutableMap.Builder typesByNameBuilder = ImmutableMap.builder();
            for (Type type : Type.values()) {
                typesByNameBuilder.put((Object)type.getName(), (Object)type);
            }
            return typesByNameBuilder.build();
        }

        private Type(String name, String defaultIdKey) {
            this.name = name;
            this.defaultIdKey = defaultIdKey;
        }

        public String getName() {
            return this.name;
        }

        public static Type getByName(String name) {
            return name == null ? null : typesByName.get(name);
        }

        public Long getDefaultId(ApplicationProperties applicationProperties) {
            String defaultAvatarId = applicationProperties.getString(this.defaultIdKey);
            return defaultAvatarId != null ? Long.valueOf(defaultAvatarId) : null;
        }

        static {
            typesByName = Type.createNameToTypeMap();
        }
    }
}

