/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.util.PageRequest;
import com.google.common.base.Objects;
import javax.annotation.Nullable;

@PublicApi
public final class PageRequests {
    public static PageRequest request(@Nullable Long start, @Nullable Integer limit) {
        return new PageRequestImpl((Long)Objects.firstNonNull((Object)start, (Object)0L), (Integer)Objects.firstNonNull((Object)limit, (Object)0x100000));
    }

    private static class PageRequestImpl
    implements PageRequest {
        private final long start;
        private final int limit;

        public PageRequestImpl(long start, int limit) {
            this.start = start < 0L ? 0L : start;
            this.limit = limit <= 0 ? 1 : Math.min(limit, 0x100000);
        }

        @Override
        public int getLimit() {
            return this.limit;
        }

        @Override
        public long getStart() {
            return this.start;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageRequestImpl that = (PageRequestImpl)o;
            if (this.limit != that.limit) {
                return false;
            }
            return this.start == that.start;
        }

        public int hashCode() {
            int result = (int)(this.start ^ this.start >>> 32);
            result = 31 * result + this.limit;
            return result;
        }
    }
}

