/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadata;
import com.google.common.base.Objects;
import javax.annotation.Nullable;

@PublicApi
public final class UpdateIssueRequest {
    private EventDispatchOption eventDispatchOption;
    private boolean sendMail;
    @Nullable
    private HistoryMetadata historyMetadata;

    private UpdateIssueRequest(UpdateIssueRequestBuilder builder) {
        this.eventDispatchOption = builder.eventDispatchOption;
        this.sendMail = builder.sendMail;
        this.historyMetadata = builder.historyMetadata;
    }

    public EventDispatchOption getEventDispatchOption() {
        return this.eventDispatchOption;
    }

    public boolean isSendMail() {
        return this.sendMail;
    }

    @Nullable
    public HistoryMetadata getHistoryMetadata() {
        return this.historyMetadata;
    }

    public static UpdateIssueRequestBuilder builder() {
        return new UpdateIssueRequestBuilder();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.eventDispatchOption, this.sendMail, this.historyMetadata});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateIssueRequest other = (UpdateIssueRequest)obj;
        return Objects.equal((Object)this.eventDispatchOption, (Object)other.eventDispatchOption) && Objects.equal((Object)this.sendMail, (Object)other.sendMail) && Objects.equal((Object)this.historyMetadata, (Object)other.historyMetadata);
    }

    public static class UpdateIssueRequestBuilder {
        private EventDispatchOption eventDispatchOption = EventDispatchOption.ISSUE_UPDATED;
        private boolean sendMail = true;
        @Nullable
        private HistoryMetadata historyMetadata;

        private UpdateIssueRequestBuilder() {
        }

        public UpdateIssueRequestBuilder eventDispatchOption(EventDispatchOption eventDispatchOption) {
            this.eventDispatchOption = eventDispatchOption;
            return this;
        }

        public UpdateIssueRequestBuilder sendMail(boolean sendMail) {
            this.sendMail = sendMail;
            return this;
        }

        public UpdateIssueRequestBuilder historyMetadata(@Nullable HistoryMetadata historyMetadata) {
            this.historyMetadata = historyMetadata;
            return this;
        }

        public UpdateIssueRequest build() {
            return new UpdateIssueRequest(this);
        }
    }
}

