/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task.context;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.task.context.Sink;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

@Internal
class CompositeSink
implements Sink {
    private final List<Sink> delegates;

    CompositeSink(Collection<? extends Sink> delegates) {
        Assertions.notNull("delegates", delegates);
        this.delegates = ImmutableList.copyOf(delegates);
    }

    @Override
    public void setName(String name) {
        Assertions.notNull("name", name);
        Iterator<Sink> i$ = this.delegates.iterator();
        while (i$.hasNext()) {
            Sink element;
            Sink delegate = element = i$.next();
            delegate.setName(name);
        }
    }

    @Override
    public void updateProgress(int progress) {
        Iterator<Sink> i$ = this.delegates.iterator();
        while (i$.hasNext()) {
            Sink element;
            Sink delegate = element = i$.next();
            delegate.updateProgress(progress);
        }
    }
}

