/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;

public class VersionIndexInfoResolver
implements IndexInfoResolver<Version> {
    private final NameResolver<Version> versionResolver;

    public VersionIndexInfoResolver(NameResolver<Version> versionResolver) {
        this.versionResolver = versionResolver;
    }

    @Override
    public List<String> getIndexedValues(String rawValue) {
        Long versionId;
        Assertions.notNull("rawValue", rawValue);
        List<String> versions = this.versionResolver.getIdsFromName(rawValue);
        if (versions.isEmpty() && (versionId = this.getValueAsLong(rawValue)) != null && this.versionResolver.idExists(versionId)) {
            versions = Collections.singletonList(rawValue);
        }
        return versions;
    }

    @Override
    public List<String> getIndexedValues(Long rawValue) {
        Assertions.notNull("rawValue", rawValue);
        if (this.versionResolver.idExists(rawValue)) {
            return ImmutableList.of((Object)rawValue.toString());
        }
        return this.versionResolver.getIdsFromName(rawValue.toString());
    }

    @Override
    public String getIndexedValue(Version version) {
        Assertions.notNull("version", version);
        return this.getIdAsString(version);
    }

    private String getIdAsString(Version version) {
        return version.getId().toString();
    }

    private Long getValueAsLong(String value) {
        try {
            return new Long(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

