/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.ErrorCollection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleErrorCollection
implements ErrorCollection,
Serializable {
    private static final long serialVersionUID = 3974433688611511656L;
    Map<String, String> errors;
    List<String> errorMessages;
    Set<ErrorCollection.Reason> reasons;

    public SimpleErrorCollection() {
        this.errors = new HashMap<String, String>(2);
        this.errorMessages = new LinkedList<String>();
        this.reasons = new HashSet<ErrorCollection.Reason>();
    }

    public SimpleErrorCollection(ErrorCollection errorCollection) {
        this.errors = new HashMap<String, String>(errorCollection.getErrors());
        this.errorMessages = new LinkedList<String>(errorCollection.getErrorMessages());
        this.reasons = new HashSet<ErrorCollection.Reason>(errorCollection.getReasons());
    }

    @Override
    public void addError(String field, String message) {
        this.errors.put(field, message);
    }

    @Override
    public void addErrorMessage(String message) {
        this.errorMessages.add(message);
    }

    @Override
    public Collection<String> getErrorMessages() {
        return this.errorMessages;
    }

    @Override
    public void setErrorMessages(Collection<String> errorMessages) {
        this.errorMessages = new ArrayList<String>(errorMessages);
    }

    @Override
    public Collection<String> getFlushedErrorMessages() {
        Collection<String> errors = this.getErrorMessages();
        this.errorMessages = new ArrayList<String>();
        return errors;
    }

    @Override
    public Map<String, String> getErrors() {
        return this.errors;
    }

    @Override
    public void addErrorCollection(ErrorCollection errors) {
        this.addErrorMessages(errors.getErrorMessages());
        this.addErrors(errors.getErrors());
        this.addReasons(errors.getReasons());
    }

    @Override
    public void addErrorMessages(Collection<String> incomingMessages) {
        if (incomingMessages != null && !incomingMessages.isEmpty()) {
            for (String incomingMessage : incomingMessages) {
                this.addErrorMessage(incomingMessage);
            }
        }
    }

    @Override
    public void addErrors(Map<String, String> incomingErrors) {
        if (incomingErrors == null) {
            return;
        }
        for (Map.Entry<String, String> mapEntry : incomingErrors.entrySet()) {
            this.addError(mapEntry.getKey(), mapEntry.getValue());
        }
    }

    @Override
    public boolean hasAnyErrors() {
        return this.errors != null && !this.errors.isEmpty() || this.errorMessages != null && !this.errorMessages.isEmpty();
    }

    @Override
    public void addError(String field, String message, ErrorCollection.Reason reason) {
        this.addError(field, message);
        this.addReason(reason);
    }

    @Override
    public void addErrorMessage(String message, ErrorCollection.Reason reason) {
        this.addErrorMessage(message);
        this.addReason(reason);
    }

    @Override
    public void addReason(ErrorCollection.Reason reason) {
        this.reasons.add(reason);
    }

    @Override
    public void addReasons(Set<ErrorCollection.Reason> reasons) {
        this.reasons.addAll(reasons);
    }

    @Override
    public void setReasons(Set<ErrorCollection.Reason> reasons) {
        this.reasons = reasons;
    }

    @Override
    public Set<ErrorCollection.Reason> getReasons() {
        return this.reasons;
    }

    public String toString() {
        return "Errors: " + this.getErrors() + "\n" + "Error Messages: " + this.getErrorMessages();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleErrorCollection that = (SimpleErrorCollection)o;
        if (!this.errorMessages.equals(that.errorMessages)) {
            return false;
        }
        if (!this.errors.equals(that.errors)) {
            return false;
        }
        return this.reasons.equals(that.reasons);
    }

    public int hashCode() {
        int result = this.errors.hashCode();
        result = 31 * result + this.errorMessages.hashCode();
        result = 31 * result + this.reasons.hashCode();
        return result;
    }
}

