/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.DataValuesExistValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.clause.TerminalClause;

public abstract class AbstractUserValidator
implements ClauseValidator {
    private final SupportedOperatorsValidator supportedOperatorsValidator = this.getSupportedOperatorsValidator();
    private final DataValuesExistValidator dataValuesExistValidator;

    public AbstractUserValidator(UserResolver userResolver, JqlOperandResolver operandResolver, I18nHelper.BeanFactory beanFactory) {
        this.dataValuesExistValidator = this.getDataValuesValidator(userResolver, operandResolver, beanFactory);
    }

    @Override
    public MessageSet validate(User searcher, TerminalClause terminalClause) {
        MessageSet errors = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!errors.hasAnyErrors()) {
            errors = this.dataValuesExistValidator.validate(searcher, terminalClause);
        }
        return errors;
    }

    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY);
    }

    DataValuesExistValidator getDataValuesValidator(UserResolver resolver, JqlOperandResolver operandResolver, I18nHelper.BeanFactory beanFactory) {
        return new DataValuesExistValidator(operandResolver, resolver, beanFactory, MessageSet.Level.WARNING);
    }
}

