/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.config.Feature;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;

@Internal
public enum CoreFeatures implements Feature
{
    ON_DEMAND,
    PREVENT_COMMENTS_LIMITING,
    LICENSE_ROLES_ENABLED;

    private static final String FEATURE_KEY_PREFIX;
    private final String featureKey;
    private final boolean isUserSettable;
    private final JiraProperties jiraSystemProperties = JiraSystemProperties.getInstance();

    private CoreFeatures() {
        this(false);
    }

    private CoreFeatures(boolean isUserSettable) {
        this.featureKey = CoreFeatures.class.getName() + '.' + this.name();
        this.isUserSettable = isUserSettable;
    }

    @Override
    public String featureKey() {
        return this.featureKey;
    }

    public String systemPropertyKey() {
        return "atlassian.darkfeature." + this.featureKey;
    }

    public boolean isDevFeature() {
        return this.isUserSettable;
    }

    public boolean isSystemPropertyEnabled() {
        return this.jiraSystemProperties.getBoolean(this.systemPropertyKey());
    }

    public static CoreFeatures forFeatureKey(String featureKey) {
        if (!featureKey.startsWith(FEATURE_KEY_PREFIX)) {
            return null;
        }
        try {
            return CoreFeatures.valueOf(featureKey.substring(FEATURE_KEY_PREFIX.length()));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    static {
        FEATURE_KEY_PREFIX = CoreFeatures.class.getName() + '.';
    }
}

