/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinkJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinkTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueRefJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.PriorityJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.StatusJsonBean;
import com.atlassian.jira.issue.link.IssueLinkType;
import java.net.URI;

public class IssueLinkBeanBuilder {
    private final JiraBaseUrls jiraBaseUrls;

    public IssueLinkBeanBuilder(JiraBaseUrls jiraBaseUrls) {
        this.jiraBaseUrls = jiraBaseUrls;
    }

    public IssueLinkJsonBean buildIssueLinkBean(IssueLinkType issueLinkType, String id) {
        URI linkTypeURI = URI.create(this.jiraBaseUrls.restApi2BaseUrl() + "issueLinkType/" + issueLinkType.getId());
        URI selfURI = URI.create(this.jiraBaseUrls.restApi2BaseUrl() + "issueLink/" + id);
        IssueLinkJsonBean issueLink = new IssueLinkJsonBean().type(IssueLinkTypeJsonBean.create(issueLinkType, linkTypeURI));
        issueLink.self(selfURI);
        issueLink.id(id);
        return issueLink;
    }

    public IssueRefJsonBean createIssueRefJsonBean(Issue issue) {
        return new IssueRefJsonBean().id(String.valueOf(issue.getId())).key(issue.getKey()).self(URI.create(this.jiraBaseUrls.restApi2BaseUrl() + "issue/" + issue.getId())).fields(new IssueRefJsonBean.Fields().summary(issue.getSummary()).status(StatusJsonBean.bean(issue.getStatusObject(), this.jiraBaseUrls)).issueType(IssueTypeJsonBean.shortBean(issue.getIssueTypeObject(), this.jiraBaseUrls)).priority(PriorityJsonBean.shortBean(issue.getPriorityObject(), this.jiraBaseUrls)));
    }
}

