/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.List;

public class VersionResolver
implements NameResolver<Version> {
    private final VersionManager versionManager;

    public VersionResolver(VersionManager versionManager) {
        this.versionManager = versionManager;
    }

    @Override
    public List<String> getIdsFromName(String name) {
        Assertions.notNull("name", name);
        Collection<Version> versions = this.versionManager.getVersionsByName(name);
        Function<Version, String> function = new Function<Version, String>(){

            @Override
            public String get(Version input) {
                return input.getId().toString();
            }
        };
        return CollectionUtil.transform(versions, function);
    }

    @Override
    public boolean nameExists(String name) {
        Assertions.notNull("name", name);
        Collection<Version> versions = this.versionManager.getVersionsByName(name);
        return !versions.isEmpty();
    }

    @Override
    public boolean idExists(Long id) {
        Assertions.notNull("id", id);
        return this.versionManager.getVersion(id) != null;
    }

    @Override
    public Version get(Long id) {
        return this.versionManager.getVersion(id);
    }

    @Override
    public Collection<Version> getAll() {
        return this.versionManager.getAllVersions();
    }
}

