/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.JqlLocalDateSupport;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractLocalDateOperatorQueryFactory {
    private final JqlLocalDateSupport jqlLocalDateSupport;

    protected AbstractLocalDateOperatorQueryFactory(JqlLocalDateSupport jqlLocalDateSupport) {
        this.jqlLocalDateSupport = Assertions.notNull("jqlLocalDateSupport", jqlLocalDateSupport);
    }

    List<LocalDate> getLocalDateValues(List<QueryLiteral> rawValues) {
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        for (QueryLiteral rawValue : rawValues) {
            LocalDate localDate;
            if (rawValue.getLongValue() != null) {
                localDate = this.jqlLocalDateSupport.convertToLocalDate(rawValue.getLongValue());
                if (localDate == null) continue;
                dates.add(localDate);
                continue;
            }
            if (rawValue.getStringValue() != null) {
                localDate = this.jqlLocalDateSupport.convertToLocalDate(rawValue.getStringValue());
                if (localDate == null) continue;
                dates.add(localDate);
                continue;
            }
            dates.add(null);
        }
        return dates;
    }
}

