/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.Nonnull;

class TransformingEnclosedIterable<I, O>
implements EnclosedIterable<O> {
    private final EnclosedIterable<I> delegate;
    private final Function<I, O> transformer;

    TransformingEnclosedIterable(@Nonnull EnclosedIterable<I> delegate, @Nonnull Function<I, O> transformer) {
        this.delegate = Assertions.notNull("delegate", delegate);
        this.transformer = Assertions.notNull("decorator", transformer);
    }

    @Override
    public void foreach(final Consumer<O> sink) {
        this.delegate.foreach(new Consumer<I>(){

            @Override
            public void consume(I element) {
                sink.consume(TransformingEnclosedIterable.this.transformer.get(element));
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }
}

