/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.security.Permissions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

@ExperimentalApi
public final class GlobalPermissionType {
    public static final String ADMINISTER = "ADMINISTER";
    public static final String SYSTEM_ADMIN = "SYSTEM_ADMIN";
    public static final String USE = "USE";
    public static final String USER_PICKER = "USER_PICKER";
    public static final String CREATE_SHARED_OBJECTS = "CREATE_SHARED_OBJECTS";
    public static final String MANAGE_GROUP_FILTER_SUBSCRIPTIONS = "MANAGE_GROUP_FILTER_SUBSCRIPTIONS";
    public static final String BULK_CHANGE = "BULK_CHANGE";
    public static BiMap<Integer, String> GLOBAL_PERMISSION_ID_TRANSLATION = ImmutableBiMap.builder().put((Object)0, (Object)"ADMINISTER").put((Object)1, (Object)"USE").put((Object)44, (Object)"SYSTEM_ADMIN").put((Object)22, (Object)"CREATE_SHARED_OBJECTS").put((Object)24, (Object)"MANAGE_GROUP_FILTER_SUBSCRIPTIONS").put((Object)33, (Object)"BULK_CHANGE").put((Object)27, (Object)"USER_PICKER").build();
    private final String key;
    private final String nameI18nKey;
    private final String descriptionI18nKey;
    private final boolean anonymousAllowed;

    public static Set<String> getUsePermissions() {
        TreeSet<String> ret = new TreeSet<String>();
        ret.add(ADMINISTER);
        ret.add(USE);
        ret.add(SYSTEM_ADMIN);
        return Collections.unmodifiableSet(ret);
    }

    public GlobalPermissionType(String key, String nameI18nKey, String descriptionI18nKey, boolean anonymousAllowed) {
        this.key = key;
        this.nameI18nKey = nameI18nKey;
        this.descriptionI18nKey = descriptionI18nKey;
        this.anonymousAllowed = anonymousAllowed;
    }

    public GlobalPermissionType(Permissions.Permission permission, boolean anonymousAllowed) {
        this.key = permission.name();
        this.nameI18nKey = permission.getNameKey();
        this.descriptionI18nKey = permission.getDescriptionKey();
        this.anonymousAllowed = anonymousAllowed;
    }

    public String getKey() {
        return this.key;
    }

    public String getNameI18nKey() {
        return this.nameI18nKey;
    }

    public String getDescriptionI18nKey() {
        return this.descriptionI18nKey;
    }

    public boolean isAnonymousAllowed() {
        return this.anonymousAllowed;
    }
}

