/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity.property;

import com.atlassian.annotations.ExperimentalApi;
import java.util.HashMap;
import java.util.Map;

@ExperimentalApi
public class EntityPropertyType {
    public static final EntityPropertyType REMOTE_VERSION_LINK = new EntityPropertyType("RemoteVersionLink", "issue.remoteissuelink", "REMOTEVERLINKPROP", "issue.remoteissuelink");
    public static final EntityPropertyType ISSUE_PROPERTY = new EntityPropertyType("IssueProperty", "common.concepts.issue", "ISSUEPROP", "issue.property");
    public static final EntityPropertyType PROJECT_PROPERTY = new EntityPropertyType("ProjectProperty", "common.concepts.project", "PROJECTPROP", "project.property");
    public static final EntityPropertyType COMMENT_PROPERTY = new EntityPropertyType("CommentProperty", "common.concepts.comment", "COMMENTPROP", "comment.property");
    private final String dbEntityName;
    private final String i18nKeyForEntityName;
    private final String indexPrefix;
    private final String jqlName;
    private static final Map<String, EntityPropertyType> jqlClauseToProperty = new HashMap<String, EntityPropertyType>();

    public EntityPropertyType(String dbEntityName, String i18nKeyForEntityName, String indexPrefix, String jqlName) {
        this.dbEntityName = dbEntityName;
        this.i18nKeyForEntityName = i18nKeyForEntityName;
        this.indexPrefix = indexPrefix;
        this.jqlName = jqlName;
    }

    public String getDbEntityName() {
        return this.dbEntityName;
    }

    public String getI18nKeyForEntityName() {
        return this.i18nKeyForEntityName;
    }

    public String getJqlName() {
        return this.jqlName;
    }

    public String getIndexPrefix() {
        return this.indexPrefix;
    }

    public static boolean isJqlClause(String clauseName) {
        return clauseName != null && jqlClauseToProperty.containsKey(clauseName);
    }

    public static EntityPropertyType getEntityPropertyTypeForClause(String clauseName) {
        return jqlClauseToProperty.get(clauseName);
    }

    static {
        jqlClauseToProperty.put(ISSUE_PROPERTY.getJqlName(), ISSUE_PROPERTY);
    }
}

