/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.DecoratingSet;
import com.atlassian.jira.util.collect.MultiMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiMaps {
    public static <K, V, C extends Collection<V>> MultiMap<K, V, C> create(Map<K, C> basedOn, Supplier<C> collectionFactory) {
        return new MultiImpl(basedOn, collectionFactory);
    }

    public static <K, V, C extends Collection<V>> MultiMap<K, V, C> create(Supplier<C> collectionFactory) {
        return new MultiImpl(new HashMap(), collectionFactory);
    }

    public static <K, V> MultiMap<K, V, List<V>> createListMultiMap() {
        return MultiMaps.create(new ListSupplier());
    }

    public static <K, V> MultiMap<K, V, Set<V>> createSetMultiMap() {
        return MultiMaps.create(new SetSupplier());
    }

    public static <K, V> MultiMap<K, V, List<V>> unmodifiableListMultiMap(MultiMap<K, V, List<V>> multiMap) {
        return new UnmodifiableMultiMap<K, V, List<V>>(multiMap, new Function<List<V>, List<V>>(){

            @Override
            public List<V> get(List<V> input) {
                return Collections.unmodifiableList(input);
            }
        });
    }

    public static <K, V> MultiMap<K, V, Set<V>> unmodifiableSetMultiMap(MultiMap<K, V, Set<V>> multiMap) {
        return new UnmodifiableMultiMap<K, V, Set<V>>(multiMap, new Function<Set<V>, Set<V>>(){

            @Override
            public Set<V> get(Set<V> input) {
                return Collections.unmodifiableSet(input);
            }
        });
    }

    static class UnmodifiableMultiMap<K, V, C extends Collection<V>>
    extends AbstractMap<K, C>
    implements MultiMap<K, V, C> {
        private final MultiMap<K, V, C> delegate;
        private final Function<C, C> unmodifiableTransformer;

        UnmodifiableMultiMap(MultiMap<K, V, C> delegate, Function<C, C> unmodifiableTransformer) {
            this.delegate = delegate;
            this.unmodifiableTransformer = unmodifiableTransformer;
        }

        @Override
        public C allValues() {
            return (C)((Collection)this.unmodifiableTransformer.get(this.delegate.allValues()));
        }

        @Override
        public Set<Map.Entry<K, C>> entrySet() {
            Set delegateSet = this.delegate.entrySet();
            return new DecoratingSet<Map.Entry<K, C>>(delegateSet, new Function<Map.Entry<K, C>, Map.Entry<K, C>>(){

                @Override
                public Map.Entry<K, C> get(final Map.Entry<K, C> input) {
                    return new Map.Entry<K, C>(){

                        @Override
                        public K getKey() {
                            return input.getKey();
                        }

                        @Override
                        public C getValue() {
                            return (Collection)UnmodifiableMultiMap.this.unmodifiableTransformer.get(input.getValue());
                        }

                        @Override
                        public C setValue(C ignore) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public int hashCode() {
                            return ((Object)input).hashCode();
                        }

                        @Override
                        public boolean equals(Object o) {
                            return ((Object)input).equals(o);
                        }
                    };
                }
            });
        }

        @Override
        public C put(K key, C value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean putSingle(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends C> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public C remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<C> values() {
            return CollectionUtil.transform(this.delegate.values(), this.unmodifiableTransformer);
        }

        @Override
        public boolean contains(Object value) {
            return this.delegate.contains(value);
        }

        @Override
        public boolean containsValue(Collection<?> value) {
            return this.delegate.containsValue(value);
        }

        @Override
        public void copyTo(Collection<V> copyTo) {
            this.delegate.copyTo(copyTo);
        }

        @Override
        public int sizeAll() {
            return this.delegate.sizeAll();
        }
    }

    static class MultiImpl<K, V, C extends Collection<V>>
    extends AbstractMap<K, C>
    implements MultiMap<K, V, C> {
        private final Map<K, C> delegate;
        private final Supplier<C> collectionFactory;

        public MultiImpl(Map<K, C> delegate, Supplier<C> collectionFactory) {
            this.delegate = delegate;
            this.collectionFactory = collectionFactory;
        }

        @Override
        public C allValues() {
            Collection result = (Collection)this.collectionFactory.get();
            for (Collection collection : this.values()) {
                result.addAll(collection);
            }
            return (C)result;
        }

        @Override
        public Set<Map.Entry<K, C>> entrySet() {
            return this.delegate.entrySet();
        }

        @Override
        public C put(K key, C value) {
            return (C)((Collection)this.delegate.put(key, value));
        }

        @Override
        public boolean putSingle(K key, V value) {
            Collection collection = (Collection)this.delegate.get(key);
            if (collection == null) {
                collection = (Collection)this.collectionFactory.get();
                this.delegate.put(key, collection);
            }
            return collection.add(value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends C> t) {
            this.delegate.putAll(t);
        }

        @Override
        public Collection<C> values() {
            return this.delegate.values();
        }

        @Override
        public boolean contains(Object value) {
            for (Collection collection : this.values()) {
                if (!collection.contains(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsValue(Collection<?> value) {
            return super.containsValue(value);
        }

        @Override
        public void copyTo(Collection<V> copyTo) {
            for (Collection collection : this.values()) {
                copyTo.addAll(collection);
            }
        }

        @Override
        public int sizeAll() {
            int result = 0;
            for (Collection collection : this.values()) {
                result += collection.size();
            }
            return result;
        }
    }

    static class SetSupplier<V>
    implements Supplier<Set<V>> {
        SetSupplier() {
        }

        @Override
        public Set<V> get() {
            return new HashSet();
        }
    }

    static class ListSupplier<V>
    implements Supplier<List<V>> {
        ListSupplier() {
        }

        @Override
        public List<V> get() {
            return new ArrayList();
        }
    }
}

