/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.DefaultCustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.SortableCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldContextValueGeneratingClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.VersionCustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.VersionCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.VersionCustomFieldIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.VersionSearchContextVisibilityChecker;
import com.atlassian.jira.issue.statistics.CustomFieldVersionStatisticsMapper;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ContextSetUtil;
import com.atlassian.jira.jql.context.CustomFieldClauseContextFactory;
import com.atlassian.jira.jql.context.FieldConfigSchemeClauseContextUtil;
import com.atlassian.jira.jql.context.IntersectingClauseContextFactory;
import com.atlassian.jira.jql.context.MultiClauseDecoratorContextFactory;
import com.atlassian.jira.jql.context.VersionClauseContextFactory;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.VersionCustomFieldClauseQueryFactory;
import com.atlassian.jira.jql.resolver.VersionIndexInfoResolver;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.jira.jql.validator.VersionCustomFieldValidator;
import com.atlassian.jira.jql.values.VersionClauseValuesGenerator;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

@PublicSpi
@PublicApi
public class VersionSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher,
SortableCustomFieldSearcher,
CustomFieldStattable {
    private final VersionManager versionManager;
    private final VersionResolver versionResolver;
    private final JqlOperandResolver operandResolver;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final FieldFlagOperandRegistry fieldFlagOperandRegistry;
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;
    private volatile CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;
    private final ClauseContextFactory versionClauseContextFactory;
    private final PermissionManager permissionManager;
    private final ContextSetUtil contextSetUtil;
    private final FieldConfigSchemeClauseContextUtil clauseContextUtil;
    private final CustomFieldInputHelper customFieldInputHelper;
    private final I18nHelper.BeanFactory beanFactory = ComponentAccessor.getI18nHelperFactory();

    public VersionSearcher(VersionManager versionManager, FieldVisibilityManager fieldVisibilityManager, VersionResolver versionResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, VersionClauseContextFactory versionClauseContextFactory, PermissionManager permissionManager, ContextSetUtil contextSetUtil, FieldConfigSchemeClauseContextUtil clauseContextUtil, CustomFieldInputHelper customFieldInputHelper) {
        this.clauseContextUtil = Assertions.notNull("clauseContextUtil", clauseContextUtil);
        this.contextSetUtil = Assertions.notNull("contextSetUtil", contextSetUtil);
        this.permissionManager = Assertions.notNull("permissionManager", permissionManager);
        this.versionClauseContextFactory = versionClauseContextFactory;
        this.versionManager = Assertions.notNull("versionManager", versionManager);
        this.versionResolver = Assertions.notNull("versionResolver", versionResolver);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
        this.fieldVisibilityManager = Assertions.notNull("fieldVisibilityManager", fieldVisibilityManager);
        this.fieldFlagOperandRegistry = Assertions.notNull("fieldFlagOperandRegistry", fieldFlagOperandRegistry);
        this.customFieldInputHelper = Assertions.notNull("customFieldInputHelper", customFieldInputHelper);
    }

    public VersionSearcher(VersionManager versionManager, FieldVisibilityManager fieldVisibilityManager, VersionResolver versionResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, VersionClauseContextFactory versionClauseContextFactory, PermissionManager permissionManager, ContextSetUtil contextSetUtil, FieldConfigSchemeClauseContextUtil clauseContextUtil, MultiClauseDecoratorContextFactory.Factory multiFactory, CustomFieldInputHelper customFieldInputHelper) {
        this.clauseContextUtil = Assertions.notNull("clauseContextUtil", clauseContextUtil);
        this.contextSetUtil = Assertions.notNull("contextSetUtil", contextSetUtil);
        this.permissionManager = Assertions.notNull("permissionManager", permissionManager);
        this.versionClauseContextFactory = versionClauseContextFactory;
        this.versionManager = Assertions.notNull("versionManager", versionManager);
        this.versionResolver = Assertions.notNull("versionResolver", versionResolver);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
        this.fieldVisibilityManager = Assertions.notNull("fieldVisibilityManager", fieldVisibilityManager);
        this.fieldFlagOperandRegistry = Assertions.notNull("fieldFlagOperandRegistry", fieldFlagOperandRegistry);
        this.customFieldInputHelper = Assertions.notNull("customFieldInputHelper", customFieldInputHelper);
    }

    @Override
    public void init(CustomField field) {
        ClauseNames names = field.getClauseNames();
        VersionSearchContextVisibilityChecker searchContextVisibilityChecker = new VersionSearchContextVisibilityChecker(this.versionManager);
        VersionIndexInfoResolver versionIndexInfoResolver = new VersionIndexInfoResolver(this.versionResolver);
        VersionCustomFieldIndexer indexer = new VersionCustomFieldIndexer(this.fieldVisibilityManager, field);
        DefaultCustomFieldValueProvider customFieldValueProvider = new DefaultCustomFieldValueProvider();
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchRenderer = new VersionCustomFieldRenderer(names, this.versionManager, this.fieldVisibilityManager, this.getDescriptor(), customFieldValueProvider, field);
        this.searchInputTransformer = new VersionCustomFieldSearchInputTransformer(this.searcherInformation.getId(), names, field, versionIndexInfoResolver, this.operandResolver, this.fieldFlagOperandRegistry, this.versionResolver, this.customFieldInputHelper, this.versionManager);
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldContextValueGeneratingClauseHandler(new VersionCustomFieldValidator(this.versionResolver, this.operandResolver, this.permissionManager, this.versionManager, this.beanFactory), new VersionCustomFieldClauseQueryFactory(field.getId(), this.versionResolver, this.operandResolver), new IntersectingClauseContextFactory(this.contextSetUtil, CollectionBuilder.newBuilder(new CustomFieldClauseContextFactory(field, this.clauseContextUtil, ContextSetUtil.getInstance()), this.versionClauseContextFactory).asList()), new VersionClauseValuesGenerator(this.versionManager, this.permissionManager, this.beanFactory), OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, JiraDataTypes.VERSION);
    }

    @Override
    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation off uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    @Override
    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer off uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    @Override
    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer off uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    @Override
    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler off uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }

    @Override
    public LuceneFieldSorter getSorter(CustomField customField) {
        return new CustomFieldVersionStatisticsMapper(customField, this.versionManager, ComponentAccessor.getJiraAuthenticationContext(), this.customFieldInputHelper, false);
    }

    @Override
    public StatisticsMapper getStatisticsMapper(CustomField customField) {
        return new CustomFieldVersionStatisticsMapper(customField, this.versionManager, ComponentAccessor.getJiraAuthenticationContext(), this.customFieldInputHelper, false);
    }
}

