/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.type;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.event.type.EventType;

@PublicApi
public interface EventDispatchOption {
    public static final EventDispatchOption DO_NOT_DISPATCH = new EventDispatchOptionImpl();
    public static final EventDispatchOption ISSUE_UPDATED = new EventDispatchOptionImpl(EventType.ISSUE_UPDATED_ID);
    public static final EventDispatchOption ISSUE_ASSIGNED = new EventDispatchOptionImpl(EventType.ISSUE_ASSIGNED_ID);
    public static final EventDispatchOption ISSUE_DELETED = new EventDispatchOptionImpl(EventType.ISSUE_DELETED_ID);

    public boolean isEventBeingSent();

    public Long getEventTypeId();

    public static class EventDispatchOptionImpl
    implements EventDispatchOption {
        private final Long eventTypeId;

        EventDispatchOptionImpl() {
            this.eventTypeId = null;
        }

        EventDispatchOptionImpl(Long eventTypeId) {
            if (eventTypeId == null) {
                throw new IllegalArgumentException("Use DO_NOT_DISPATCH if you want a null");
            }
            this.eventTypeId = eventTypeId;
        }

        @Override
        public boolean isEventBeingSent() {
            return this.eventTypeId != null;
        }

        @Override
        public Long getEventTypeId() {
            return this.eventTypeId;
        }
    }

    public static final class Factory {
        public static EventDispatchOption get(Long id) {
            return new EventDispatchOptionImpl(id);
        }
    }
}

