/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.AbstractLocalDateOperatorQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.TermQueryFactory;
import com.atlassian.jira.jql.util.JqlLocalDateSupport;
import com.atlassian.query.operator.Operator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;

public class LocalDateEqualityQueryFactory
extends AbstractLocalDateOperatorQueryFactory
implements OperatorSpecificQueryFactory {
    private static final Logger log = Logger.getLogger(LocalDateEqualityQueryFactory.class);
    private final JqlLocalDateSupport jqlLocalDateSupport;

    public LocalDateEqualityQueryFactory(JqlLocalDateSupport jqlLocalDateSupport) {
        super(jqlLocalDateSupport);
        this.jqlLocalDateSupport = jqlLocalDateSupport;
    }

    @Override
    public QueryFactoryResult createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator != Operator.EQUALS && operator != Operator.NOT_EQUALS) {
            log.debug((Object)String.format("Creating an equality query for a single value for date field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s' and '%s'", new Object[]{fieldName, operator, Operator.EQUALS, Operator.NOT_EQUALS}));
            return QueryFactoryResult.createFalseResult();
        }
        return this.createResult(fieldName, operator, rawValues);
    }

    @Override
    public QueryFactoryResult createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.NOT_IN) {
            return this.createResult(fieldName, operator, rawValues);
        }
        log.debug((Object)String.format("Creating an equality query for multiple values for date field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s' and '%s'", new Object[]{fieldName, operator, Operator.IN, Operator.NOT_IN}));
        return QueryFactoryResult.createFalseResult();
    }

    private QueryFactoryResult createResult(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.EQUALS) {
            return this.handleIn(fieldName, this.getLocalDateValues(rawValues));
        }
        if (operator == Operator.NOT_IN || operator == Operator.NOT_EQUALS) {
            return this.handleNotIn(fieldName, this.getLocalDateValues(rawValues));
        }
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public QueryFactoryResult createQueryForEmptyOperand(String fieldName, Operator operator) {
        if (operator == Operator.IS || operator == Operator.EQUALS) {
            return new QueryFactoryResult(this.getIsEmptyQuery(fieldName));
        }
        if (operator == Operator.IS_NOT || operator == Operator.NOT_EQUALS) {
            return new QueryFactoryResult(this.getIsNotEmptyQuery(fieldName));
        }
        log.debug((Object)String.format("Creating an equality query for an empty value for date field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s','%s', '%s' and '%s'", new Object[]{fieldName, operator, Operator.IS, Operator.EQUALS, Operator.IS_NOT, Operator.NOT_EQUALS}));
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator);
    }

    private Query handleEquals(String fieldName, LocalDate value) {
        return new TermQuery(new Term(fieldName, this.jqlLocalDateSupport.getIndexedValue(value)));
    }

    private Query handleNotEquals(String fieldName, LocalDate value) {
        BooleanQuery combined = new BooleanQuery();
        String indexedValue = this.jqlLocalDateSupport.getIndexedValue(value);
        combined.add((Query)new TermRangeQuery(fieldName, null, indexedValue, true, false), BooleanClause.Occur.SHOULD);
        combined.add((Query)new TermRangeQuery(fieldName, indexedValue, null, false, true), BooleanClause.Occur.SHOULD);
        return combined;
    }

    private QueryFactoryResult handleIn(String fieldName, List<LocalDate> values) {
        if (values.size() == 1) {
            LocalDate localDate = values.get(0);
            Query query = localDate == null ? this.getIsEmptyQuery(fieldName) : this.handleEquals(fieldName, localDate);
            return new QueryFactoryResult(query);
        }
        BooleanQuery combined = new BooleanQuery();
        for (LocalDate value : values) {
            if (value == null) {
                combined.add(this.getIsEmptyQuery(fieldName), BooleanClause.Occur.SHOULD);
                continue;
            }
            combined.add(this.handleEquals(fieldName, value), BooleanClause.Occur.SHOULD);
        }
        return new QueryFactoryResult((Query)combined);
    }

    private QueryFactoryResult handleNotIn(String fieldName, List<LocalDate> values) {
        if (values.size() == 1) {
            LocalDate date = values.get(0);
            Query query = date == null ? this.getIsNotEmptyQuery(fieldName) : this.handleNotEquals(fieldName, date);
            return new QueryFactoryResult(query);
        }
        BooleanQuery combined = new BooleanQuery();
        for (LocalDate value : values) {
            if (value == null) {
                combined.add(this.getIsNotEmptyQuery(fieldName), BooleanClause.Occur.SHOULD);
                continue;
            }
            combined.add(this.handleNotEquals(fieldName, value), BooleanClause.Occur.MUST);
        }
        return new QueryFactoryResult((Query)combined);
    }

    private Query getIsEmptyQuery(String fieldName) {
        QueryFactoryResult result = new QueryFactoryResult(TermQueryFactory.nonEmptyQuery(fieldName), true);
        return QueryFactoryResult.wrapWithVisibilityQuery(fieldName, result).getLuceneQuery();
    }

    private Query getIsNotEmptyQuery(String fieldName) {
        return TermQueryFactory.nonEmptyQuery(fieldName);
    }
}

