/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.jfreechart;

import com.atlassian.core.util.RandomGenerator;
import com.atlassian.jira.charts.jfreechart.AltAndTitleTagFragmentGenerator;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.io.SessionNotFoundException;
import com.atlassian.jira.io.TempFileFactory;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.imagemap.StandardURLTagFragmentGenerator;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;
import org.jfree.chart.servlet.ServletUtilities;

public class ChartHelper {
    private static final Logger log = Logger.getLogger(ChartHelper.class);
    private final JFreeChart chart;
    private final TempFileFactory tempFileFactory;
    private ChartRenderingInfo renderingInfo;
    private String location;
    private String imageMapHtml;
    private String imageMapName;

    public ChartHelper(JFreeChart chart) {
        this(chart, ComponentAccessor.getComponent(TempFileFactory.class));
    }

    @VisibleForTesting
    public ChartHelper(JFreeChart chart, TempFileFactory tempFileFactory) {
        this.chart = chart;
        this.tempFileFactory = tempFileFactory;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(int width, int height) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ChartHelper.generate() Create a ChartRenderingInfo.");
        }
        this.renderingInfo = new ChartRenderingInfo();
        String logLine = "ChartHelper calling JFreeChart: ServletUtilities.saveChartAsPNG()";
        UtilTimerStack.push((String)"ChartHelper calling JFreeChart: ServletUtilities.saveChartAsPNG()");
        try {
            log.debug((Object)"ChartHelper.generate(): Use JFreeChart to create PNG file.");
            this.location = ServletUtilities.saveChartAsPNG((JFreeChart)this.chart, (int)width, (int)height, (ChartRenderingInfo)this.renderingInfo, null);
            log.debug((Object)("ChartHelper.generate(): PNG file created in '" + this.location + "'."));
        }
        finally {
            UtilTimerStack.pop((String)"ChartHelper calling JFreeChart: ServletUtilities.saveChartAsPNG()");
        }
    }

    public ChartRenderingInfo getRenderingInfo() {
        return this.renderingInfo;
    }

    public String getLocation() {
        return this.location;
    }

    public String getImageMap() {
        return this.getImageMapHtml();
    }

    public String getImageMapHtml() {
        if (this.imageMapHtml == null) {
            this.imageMapName = ChartHelper.generateRandomImageMapName();
            this.imageMapHtml = ImageMapUtilities.getImageMap((String)this.imageMapName, (ChartRenderingInfo)this.renderingInfo, (ToolTipTagFragmentGenerator)new AltAndTitleTagFragmentGenerator(), (URLTagFragmentGenerator)new StandardURLTagFragmentGenerator());
        }
        return this.imageMapHtml;
    }

    private static String generateRandomImageMapName() {
        return "chart-" + RandomGenerator.randomString((int)10);
    }

    public String getImageMapName() {
        return this.imageMapName;
    }

    private void markAsTemporaryFile(String location) {
        if (this.tempFileFactory != null) {
            try {
                this.tempFileFactory.makeSessionTempFile(location);
            }
            catch (SessionNotFoundException sessionNotFoundException) {
                // empty catch block
            }
        }
    }
}

