/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.builder;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import com.atlassian.query.order.SortOrder;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.apache.log4j.Logger;

@NotThreadSafe
public class JqlOrderByBuilder {
    private static final Logger log = Logger.getLogger(JqlOrderByBuilder.class);
    private List<SearchSort> searchSorts;
    private final JqlQueryBuilder parentBuilder;

    JqlOrderByBuilder(JqlQueryBuilder parentBuilder) {
        this.parentBuilder = parentBuilder;
        this.searchSorts = new LinkedList<SearchSort>();
    }

    public JqlOrderByBuilder setSorts(Collection<SearchSort> newSorts) {
        Assertions.notNull("newSorts", newSorts);
        this.searchSorts = new LinkedList<SearchSort>(newSorts);
        return this;
    }

    public JqlOrderByBuilder setSorts(OrderBy existingOrderBy) {
        if (existingOrderBy != null) {
            this.setSorts(existingOrderBy.getSearchSorts());
        }
        return this;
    }

    public Query buildQuery() {
        if (this.parentBuilder != null) {
            return this.parentBuilder.buildQuery();
        }
        return new QueryImpl(null, this.buildOrderBy(), null);
    }

    public OrderBy buildOrderBy() {
        return new OrderByImpl(Collections.unmodifiableList(this.searchSorts));
    }

    public JqlQueryBuilder endOrderBy() {
        return this.parentBuilder;
    }

    public JqlOrderByBuilder clear() {
        this.searchSorts = new LinkedList<SearchSort>();
        return this;
    }

    public JqlOrderByBuilder addSortForFieldName(String fieldName, SortOrder order, boolean makePrimarySort) {
        Assertions.notNull("fieldName", fieldName);
        SearchHandlerManager searchHandlerManager = ComponentAccessor.getComponent(SearchHandlerManager.class);
        Collection<ClauseNames> clauseNames = searchHandlerManager.getJqlClauseNames(fieldName);
        String sortName = fieldName;
        if (!clauseNames.isEmpty()) {
            sortName = clauseNames.iterator().next().getPrimaryName();
        } else {
            log.debug((Object)("Unable to find a JQL clause name for field name '" + fieldName + "', adding sort anyway."));
        }
        return this.add(sortName, order, makePrimarySort);
    }

    public JqlOrderByBuilder add(String jqlClauseName, SortOrder order, boolean makePrimarySort) {
        Assertions.notNull("jqlClauseName", jqlClauseName);
        if (makePrimarySort) {
            this.searchSorts.add(0, new SearchSort(jqlClauseName, order));
        } else {
            this.searchSorts.add(new SearchSort(jqlClauseName, order));
        }
        return this;
    }

    public JqlOrderByBuilder add(String jqlClauseName, SortOrder order) {
        return this.add(jqlClauseName, order, false);
    }

    public JqlOrderByBuilder add(String jqlClauseName) {
        return this.add(jqlClauseName, null, false);
    }

    public JqlOrderByBuilder priority(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forPriority().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder priority(SortOrder order) {
        return this.priority(order, false);
    }

    public JqlOrderByBuilder currentEstimate(SortOrder order) {
        return this.currentEstimate(order, false);
    }

    public JqlOrderByBuilder currentEstimate(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forCurrentEstimate().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder originalEstimate(SortOrder order) {
        return this.originalEstimate(order, false);
    }

    public JqlOrderByBuilder originalEstimate(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forOriginalEstimate().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder votes(SortOrder order) {
        return this.votes(order, false);
    }

    public JqlOrderByBuilder votes(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forVotes().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder watches(SortOrder order) {
        return this.watches(order, false);
    }

    public JqlOrderByBuilder watches(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forWatches().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder issueKey(SortOrder order) {
        return this.issueKey(order, false);
    }

    public JqlOrderByBuilder issueKey(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forIssueKey().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder issueId(SortOrder order) {
        return this.issueId(order, false);
    }

    public JqlOrderByBuilder issueId(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forIssueId().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder project(SortOrder order) {
        return this.project(order, false);
    }

    public JqlOrderByBuilder project(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forProject().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder issueType(SortOrder order) {
        return this.issueType(order, false);
    }

    public JqlOrderByBuilder issueType(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forIssueType().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder createdDate(SortOrder order) {
        return this.createdDate(order, false);
    }

    public JqlOrderByBuilder createdDate(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forCreatedDate().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder dueDate(SortOrder order) {
        return this.dueDate(order, false);
    }

    public JqlOrderByBuilder dueDate(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forDueDate().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder lastViewedDate(SortOrder order) {
        return this.lastViewedDate(order, false);
    }

    public JqlOrderByBuilder lastViewedDate(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forLastViewedDate().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder updatedDate(SortOrder order) {
        return this.updatedDate(order, false);
    }

    public JqlOrderByBuilder updatedDate(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forUpdatedDate().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder summary(SortOrder order) {
        return this.summary(order, false);
    }

    public JqlOrderByBuilder summary(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forSummary().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder resolution(SortOrder order) {
        return this.resolution(order, false);
    }

    public JqlOrderByBuilder resolution(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forResolution().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder status(SortOrder order) {
        return this.status(order, false);
    }

    public JqlOrderByBuilder status(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forStatus().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder component(SortOrder order) {
        return this.component(order, false);
    }

    public JqlOrderByBuilder component(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forComponent().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder affectedVersion(SortOrder order) {
        return this.affectedVersion(order, false);
    }

    public JqlOrderByBuilder affectedVersion(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forAffectedVersion().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder fixForVersion(SortOrder order) {
        return this.fixForVersion(order, false);
    }

    public JqlOrderByBuilder fixForVersion(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forFixForVersion().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder description(SortOrder order) {
        return this.description(order, false);
    }

    public JqlOrderByBuilder description(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forDescription().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder environment(SortOrder order) {
        return this.environment(order, false);
    }

    public JqlOrderByBuilder environment(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forEnvironment().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder resolutionDate(SortOrder order) {
        return this.resolutionDate(order, false);
    }

    public JqlOrderByBuilder resolutionDate(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forResolutionDate().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder reporter(SortOrder order) {
        return this.reporter(order, false);
    }

    public JqlOrderByBuilder reporter(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forReporter().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder assignee(SortOrder order) {
        return this.assignee(order, false);
    }

    public JqlOrderByBuilder assignee(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forAssignee().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder workRatio(SortOrder order) {
        return this.workRatio(order, false);
    }

    public JqlOrderByBuilder workRatio(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forWorkRatio().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder timeSpent(SortOrder order) {
        return this.timeSpent(order, false);
    }

    public JqlOrderByBuilder timeSpent(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forTimeSpent().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }

    public JqlOrderByBuilder securityLevel(SortOrder order) {
        return this.securityLevel(order, false);
    }

    public JqlOrderByBuilder securityLevel(SortOrder order, boolean makePrimarySort) {
        return this.add(SystemSearchConstants.forSecurityLevel().getJqlClauseNames().getPrimaryName(), order, makePrimarySort);
    }
}

