/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.parameters.lucene.sort.JiraLuceneFieldFinder;
import com.atlassian.jira.issue.statistics.util.HitCollectorUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

@Internal
public abstract class AbstractOneDimensionalHitCollector
extends Collector {
    private static final Logger log = Logger.getLogger(AbstractOneDimensionalHitCollector.class);
    private final String fieldId;
    private Collection<String>[] docToTerms;
    private Collection<String>[] docToProject;
    private Collection<String>[] docToIssueType;
    private String documentFieldId;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final FieldManager fieldManager;
    private final ProjectManager projectManager;
    private final ReaderCache readerCache;
    private long irrelevantCount = 0L;
    private boolean usingOldCallingConvention = false;
    private long hitCount = 0L;
    private int docBase = 0;

    public AbstractOneDimensionalHitCollector(String documentFieldId, IndexReader indexReader, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache, FieldManager fieldManager, ProjectManager projectManager) {
        this.documentFieldId = documentFieldId;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.readerCache = readerCache;
        this.fieldId = new HitCollectorUtil().getFieldId(documentFieldId);
        this.fieldManager = fieldManager;
        this.projectManager = projectManager;
        this.setNextReader(indexReader, 0);
        this.usingOldCallingConvention = true;
    }

    public AbstractOneDimensionalHitCollector(String documentFieldId, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache, FieldManager fieldManager, ProjectManager projectManager) {
        this.documentFieldId = documentFieldId;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.fieldManager = fieldManager;
        this.projectManager = projectManager;
        this.readerCache = readerCache;
        this.fieldId = new HitCollectorUtil().getFieldId(documentFieldId);
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void setNextReader(IndexReader reader, int docBase) {
        if (this.usingOldCallingConvention) {
            log.warn((Object)"You constructed an instance of AbstractOneDimensionalHitCollector using the old calling convention and passed in an index reader.  You should not be calling setNextReader() on that instance as it will cause excessive double caching of data.  This is a BAD BAD THING!!!");
        }
        this.docBase = docBase;
        this.docToTerms = AbstractOneDimensionalHitCollector.readCachedMultiValueField(reader, this.documentFieldId, this.readerCache);
        this.docToProject = AbstractOneDimensionalHitCollector.readCachedSingleValueField(reader, SystemSearchConstants.forProject().getIndexField(), this.readerCache);
        this.docToIssueType = AbstractOneDimensionalHitCollector.readCachedSingleValueField(reader, SystemSearchConstants.forIssueType().getIndexField(), this.readerCache);
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    public void collect(int i) {
        ++this.hitCount;
        Collection<String> terms = this.docToTerms[i];
        if (terms == null) {
            String issueTypeId;
            Long projectId = new Long(AbstractOneDimensionalHitCollector.getSingleValue(this.docToProject[i]));
            if (this.fieldVisibilityManager.isFieldHidden(projectId, this.fieldId, issueTypeId = AbstractOneDimensionalHitCollector.getSingleValue(this.docToIssueType[i])) || this.isFieldOutOfScope(projectId, this.fieldId, issueTypeId)) {
                ++this.irrelevantCount;
                this.collectIrrelevant(this.docBase + i);
            } else {
                this.collectWithTerms(this.docBase + i, terms);
            }
        } else {
            this.collectWithTerms(this.docBase + i, terms);
        }
    }

    private boolean isFieldOutOfScope(Long projectId, String fieldId, String issueTypeId) {
        if (fieldId == null || "".equals(fieldId) || projectId == null || issueTypeId == null || "".equals(issueTypeId)) {
            return false;
        }
        if (!this.fieldManager.isCustomField(fieldId)) {
            return false;
        }
        CustomField field = this.fieldManager.getCustomField(fieldId);
        Project project = this.projectManager.getProjectObj(projectId);
        if (project == null || field == null || issueTypeId == null) {
            return false;
        }
        ArrayList<String> issueTypeIds = new ArrayList<String>();
        issueTypeIds.add(issueTypeId);
        return !field.isInScope(project, issueTypeIds);
    }

    private static String getSingleValue(Collection<String> source) {
        return source instanceof List ? (String)((List)source).get(0) : source.iterator().next();
    }

    public long getIrrelevantCount() {
        return this.irrelevantCount;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    protected abstract void collectIrrelevant(int var1);

    protected abstract void collectWithTerms(int var1, Collection<String> var2);

    private static Collection<String>[] readCachedMultiValueField(final IndexReader indexReader, final String fieldId, ReaderCache readerCache) {
        return readerCache.get(indexReader, fieldId, new Supplier<Collection<String>[]>(){

            @Override
            public Collection<String>[] get() {
                try {
                    return JiraLuceneFieldFinder.getInstance().getMatches(indexReader, fieldId);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        });
    }

    private static Collection<String>[] readCachedSingleValueField(final IndexReader indexReader, final String fieldId, ReaderCache readerCache) {
        return readerCache.get(indexReader, fieldId, new Supplier<Collection<String>[]>(){

            @Override
            public Collection<String>[] get() {
                try {
                    return JiraLuceneFieldFinder.getInstance().getUniqueMatches(indexReader, fieldId);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        });
    }
}

