/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.ProjectManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MoveIssueBean
implements OperationContext {
    private final ConstantsManager constantsManager;
    private final ProjectManager projectManager;
    private int currentStep = 1;
    private Long issueId = null;
    private Set availablePreviousSteps = new HashSet();
    private String targetStatusId;
    private Map fieldValuesHolder;
    private Map fieldValues;
    private Map taskTargetStatusHolder;
    private Collection moveFieldLayoutItems;
    private Collection removedFields;
    private MutableIssue updatedIssue;
    private String sourceIssueKey;

    public MoveIssueBean(ConstantsManager constantsManager, ProjectManager projectManager) {
        this.constantsManager = constantsManager;
        this.projectManager = projectManager;
        this.fieldValuesHolder = new HashMap();
        this.moveFieldLayoutItems = Collections.EMPTY_LIST;
        this.removedFields = Collections.EMPTY_LIST;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(int currentStep) {
        this.currentStep = currentStep;
    }

    public Long getIssueId() {
        return this.issueId;
    }

    public void setIssueId(Long issueId) {
        this.issueId = issueId;
    }

    public void addAvailablePreviousStep(int stepId) {
        this.availablePreviousSteps.add(new Integer(stepId));
    }

    public void clearAvailablePreviousSteps() {
        this.availablePreviousSteps.clear();
    }

    public boolean isAvailablePreviousStep(int stepId) {
        return this.availablePreviousSteps.contains(new Integer(stepId));
    }

    public Long getTargetPid() {
        return (Long)this.getFieldValuesHolder().get("project");
    }

    public String getTargetProjectName() {
        return this.projectManager.getProjectObj(this.getTargetPid()).getName();
    }

    public String getTargetIssueType() {
        return (String)this.getFieldValuesHolder().get("issuetype");
    }

    public String getTargetTypeName() {
        IssueType issueType = this.constantsManager.getIssueTypeObject(this.getTargetIssueType());
        return issueType.getNameTranslation();
    }

    public String getTargetStatusId() {
        return this.targetStatusId;
    }

    public void setTargetStatusId(String targetStatusId) {
        this.targetStatusId = targetStatusId;
    }

    public String getTargetStatusName() {
        Status status = this.constantsManager.getStatusObject(this.getTargetStatusId());
        return status.getNameTranslation();
    }

    public void reset() {
        this.setTargetStatusId(null);
        this.setTaskTargetStatusHolder(null);
        this.getFieldValuesHolder().clear();
        this.setFieldValues(new HashMap());
        this.setMoveFieldLayoutItems(Collections.EMPTY_LIST);
        this.setRemovedFields(Collections.EMPTY_LIST);
        this.setUpdatedIssue(null);
    }

    @Override
    public Map getFieldValuesHolder() {
        return this.fieldValuesHolder;
    }

    @Override
    public IssueOperation getIssueOperation() {
        return IssueOperations.MOVE_ISSUE_OPERATION;
    }

    public Map getFieldValues() {
        return this.fieldValues;
    }

    public void setFieldValues(Map fieldValues) {
        this.fieldValues = fieldValues;
    }

    public Map getTaskTargetStatusHolder() {
        return this.taskTargetStatusHolder;
    }

    public void setTaskTargetStatusHolder(Map taskTargetStatusHolder) {
        this.taskTargetStatusHolder = taskTargetStatusHolder;
    }

    public Collection getMoveFieldLayoutItems() {
        return this.moveFieldLayoutItems;
    }

    public void setMoveFieldLayoutItems(Collection moveFieldLayoutItems) {
        this.moveFieldLayoutItems = moveFieldLayoutItems;
    }

    public void setUpdatedIssue(MutableIssue targetIssue) {
        this.updatedIssue = targetIssue;
    }

    public MutableIssue getUpdatedIssue() {
        return this.updatedIssue;
    }

    public Collection getRemovedFields() {
        return this.removedFields;
    }

    public void setRemovedFields(Collection removeds) {
        this.removedFields = removeds;
    }

    public String getSourceIssueKey() {
        return this.sourceIssueKey;
    }

    public void setSourceIssueKey(String sourceIssueKey) {
        this.sourceIssueKey = sourceIssueKey;
    }
}

