/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.JiraKeyUtils;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

@PublicApi
public class ServiceUtils {
    private static final String INVALID_ISSUEKEY_CHARS = "\n\r\t \"''`~,.:;<>()[]{}!@#$%^&*+=|\\/?";
    private static final Logger log = Logger.getLogger(ServiceUtils.class);

    private ServiceUtils() {
    }

    @Nullable
    @Deprecated
    public static GenericValue getIssue(String key) {
        Issue issueObject = ServiceUtils.getIssueObject(key);
        if (issueObject == null) {
            return null;
        }
        return issueObject.getGenericValue();
    }

    @Nullable
    public static Issue getIssueObject(String key) {
        Issue issue = ComponentAccessor.getIssueManager().getIssueObject(key);
        if (issue == null) {
            issue = ComponentAccessor.getIssueManager().findMovedIssue(key);
        }
        return issue;
    }

    @Deprecated
    @Nullable
    public static GenericValue findIssueInString(String searchString) {
        Issue issue = ServiceUtils.findIssueObjectInString(searchString);
        if (issue == null) {
            return null;
        }
        return issue.getGenericValue();
    }

    @Nullable
    public static Issue findIssueObjectInString(String searchString) {
        StringTokenizer tokenizer = new StringTokenizer(TextUtils.noNull((String)searchString).toUpperCase(), INVALID_ISSUEKEY_CHARS, false);
        while (tokenizer.hasMoreTokens()) {
            Issue issue;
            String token = tokenizer.nextToken();
            if (!JiraKeyUtils.validIssueKey(token) || (issue = ServiceUtils.getIssueObject(token)) == null) continue;
            return issue;
        }
        return null;
    }

    @Deprecated
    public static GenericValue[] findIssuesInString(String searchString) {
        if (searchString == null) {
            return null;
        }
        ArrayList<GenericValue> al = new ArrayList<GenericValue>();
        StringTokenizer tokenizer = new StringTokenizer(searchString, INVALID_ISSUEKEY_CHARS, false);
        while (tokenizer.hasMoreTokens()) {
            GenericValue issue;
            String token = tokenizer.nextToken();
            if (!JiraKeyUtils.validIssueKey(token) || (issue = ServiceUtils.getIssue(token)) == null) continue;
            al.add(issue);
        }
        return al.toArray(new GenericValue[al.size()]);
    }

    public static Iterable<Issue> findIssueObjectsInString(String searchString) {
        if (searchString == null) {
            return Collections.emptyList();
        }
        ArrayList<Issue> al = new ArrayList<Issue>();
        StringTokenizer tokenizer = new StringTokenizer(searchString, INVALID_ISSUEKEY_CHARS, false);
        while (tokenizer.hasMoreTokens()) {
            Issue issue;
            String token = tokenizer.nextToken();
            if (!JiraKeyUtils.validIssueKey(token) || (issue = ServiceUtils.getIssueObject(token)) == null) continue;
            al.add(issue);
        }
        return al;
    }

    public static Map<String, String> getParameterMap(String parameterString) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (parameterString != null) {
            StringTokenizer st = new StringTokenizer(parameterString, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                int equalIdx = token.indexOf(61);
                if (equalIdx < 0) continue;
                String paramName = token.substring(0, equalIdx);
                String paramValue = null;
                if (equalIdx + 1 < token.length()) {
                    paramValue = token.substring(equalIdx + 1);
                }
                params.put(paramName, paramValue);
            }
        }
        return params;
    }

    public static String toParameterString(Map<String, String> params) {
        return Joiner.on((String)",").join(Iterables.transform(params.entrySet(), (Function)new Function<Map.Entry<String, String>, String>(){

            public String apply(Map.Entry<String, String> from) {
                return from.getKey() + "=" + from.getValue();
            }
        }));
    }
}

