/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.web.util.HelpPaths;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class HelpUtil {
    static final String HELP_PATH_CONFIG_LOCATION = "help-paths.properties";
    static final String INTERNAL_HELP_PATH_CONFIG_LOCATION = "internal-help-paths.properties";
    static final String OD_EVAL_LICENSE_CAMPAIGN = "qAwr63Ru";
    static final String OD_STARTER_LICENSE_CAMPAIGN = "nEJAsw6b";
    static final String OD_FULL_LICENSE_CAMPAIGN = "r4BuneYU";
    static final String OD_ENTERPRISE_LICENSE_CAMPAIGN = "yuX3vawa";
    private static final Logger log = Logger.getLogger(HelpUtil.class);
    @Nonnull
    private HelpPaths helpPathsWithOverrides;
    @Nonnull
    private final HelpPaths helpPathsWithNoOverrides;

    public static HelpUtil getInstance() {
        return new HelpUtil();
    }

    public HelpUtil() {
        this.helpPathsWithOverrides = HelpPathsHolder.WITH_OVERRIDES;
        this.helpPathsWithNoOverrides = HelpPathsHolder.NO_OVERRIDES;
    }

    public HelpUtil(Properties externalProperties) {
        this.helpPathsWithOverrides = HelpUtil.createHelpPaths(externalProperties, null, true);
        this.helpPathsWithNoOverrides = HelpUtil.createHelpPaths(externalProperties, null, false);
    }

    public HelpUtil(String externalPropertiesFileLocation, String internalPropertiesFileLocation) {
        this.helpPathsWithOverrides = HelpUtil.createHelpPaths(externalPropertiesFileLocation, internalPropertiesFileLocation, true);
        this.helpPathsWithNoOverrides = HelpUtil.createHelpPaths(externalPropertiesFileLocation, internalPropertiesFileLocation, false);
    }

    public HelpPath getHelpPath(String helpPathKey) {
        return this.getHelpPath(helpPathKey, true);
    }

    public HelpPath getHelpPath(String helpPathKey, boolean useOnDemandOverrides) {
        HelpPaths.ImmutableHelpPath path = useOnDemandOverrides ? this.helpPathsWithOverrides.get(helpPathKey) : this.helpPathsWithNoOverrides.get(helpPathKey);
        return new HelpPath(path.url, path.alt, path.title, path.key, path.local);
    }

    public Set<String> keySet() {
        return Sets.newHashSet(this.helpPathsWithOverrides.keys());
    }

    @Nonnull
    private static HelpPaths createHelpPaths(String externalPropertiesFileLocation, @Nullable String internalPropertiesFileLocation, boolean useOnDemandOverrides) {
        Properties externalProps = HelpUtil.loadProperties(externalPropertiesFileLocation);
        Properties internalProps = HelpUtil.loadProperties(internalPropertiesFileLocation);
        return HelpUtil.createHelpPaths(externalProps, internalProps, useOnDemandOverrides);
    }

    @Nonnull
    private static HelpPaths createHelpPaths(Properties externalProperties, @Nullable Properties internalProperties, boolean useOnDemandOverrides) {
        return new HelpPaths(externalProperties, internalProperties, useOnDemandOverrides);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String propertiesFileLocation) {
        Properties properties = new Properties();
        if (propertiesFileLocation != null) {
            InputStream is = ClassLoaderUtils.getResourceAsStream((String)propertiesFileLocation, HelpUtil.class);
            try {
                properties.load(is);
            }
            catch (IOException e) {
                log.error((Object)("Error loading helpfile " + propertiesFileLocation + ": " + e), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return properties;
    }

    static /* synthetic */ HelpPaths access$000(String x0, String x1, boolean x2) {
        return HelpUtil.createHelpPaths(x0, x1, x2);
    }

    private static class HelpPathsHolder {
        static final HelpPaths WITH_OVERRIDES = HelpUtil.access$000("help-paths.properties", "internal-help-paths.properties", true);
        static final HelpPaths NO_OVERRIDES = HelpUtil.access$000("help-paths.properties", "internal-help-paths.properties", false);

        private HelpPathsHolder() {
        }
    }

    public class HelpPath
    implements Cloneable {
        String url;
        String alt;
        String title;
        String key;
        Boolean local;

        public HelpPath() {
        }

        HelpPath(String url, String alt, String title, String key, Boolean local) {
            this.url = url;
            this.alt = alt;
            this.title = title;
            this.key = key;
            this.local = local;
        }

        public String getUrl() {
            return this.url + this.getAnalyticsSuffix();
        }

        private String getAnalyticsSuffix() {
            String analyticsSuffix = "";
            JiraLicenseManager licenseManager = ComponentAccessor.getComponent(JiraLicenseManager.class);
            if (licenseManager == null) {
                return analyticsSuffix;
            }
            LicenseDetails licenseDetails = licenseManager.getLicense();
            if (licenseDetails.isOnDemand()) {
                String analyticsParam = "";
                if (licenseDetails.isEvaluation()) {
                    analyticsParam = HelpUtil.OD_EVAL_LICENSE_CAMPAIGN;
                } else if (licenseDetails.getMaximumNumberOfUsers() == 10) {
                    analyticsParam = HelpUtil.OD_STARTER_LICENSE_CAMPAIGN;
                } else if (licenseDetails.getMaximumNumberOfUsers() > 500 || licenseDetails.isUnlimitedNumberOfUsers()) {
                    analyticsParam = HelpUtil.OD_ENTERPRISE_LICENSE_CAMPAIGN;
                } else if (licenseDetails.getMaximumNumberOfUsers() > 10) {
                    analyticsParam = HelpUtil.OD_FULL_LICENSE_CAMPAIGN;
                }
                if (!Strings.isNullOrEmpty((String)analyticsParam)) {
                    analyticsSuffix = "?utm_campaign=" + analyticsParam + "&utm_medium=navbar&utm_source=inproduct";
                }
            }
            return analyticsSuffix;
        }

        public String getAlt() {
            return this.alt;
        }

        public String getTitle() {
            return this.title;
        }

        public String getKey() {
            return this.key;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setAlt(String alt) {
            this.alt = alt;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Boolean isLocal() {
            return this.local;
        }

        public Boolean getLocal() {
            return this.local;
        }

        public void setLocal(Boolean local) {
            this.local = local;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("url", (Object)this.url).append("title", (Object)this.title).append("key", (Object)this.key).append("alt", (Object)this.alt).toString();
        }
    }
}

