/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task.context;

import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.PercentageContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.commons.lang.StringUtils;

class TaskProgressPercentageContextSink
implements PercentageContext.Sink {
    private final I18nHelper i18nHelper;
    private final TaskProgressSink progressSink;
    private volatile String currentIndex;

    TaskProgressPercentageContextSink(I18nHelper i18nHelper, TaskProgressSink progressSink) {
        Assertions.notNull("i18nHelper", i18nHelper);
        Assertions.notNull("progressSink", progressSink);
        this.i18nHelper = i18nHelper;
        this.progressSink = progressSink;
    }

    @Override
    public void setName(String currentIndex) {
        this.currentIndex = currentIndex;
    }

    @Override
    public void updateProgress(int progress) {
        String message = this.i18nHelper.getText("admin.indexing.percent.complete", new Integer(progress));
        String sub = StringUtils.isBlank((String)this.currentIndex) ? null : this.i18nHelper.getText("admin.indexing.current.index", this.currentIndex);
        this.progressSink.makeProgress(progress, sub, message);
    }
}

