/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.statistics.util.FieldValueToDisplayTransformer;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.util.I18nHelper;
import com.opensymphony.util.TextUtils;
import org.ofbiz.core.entity.GenericValue;

public class DefaultFieldValueToDisplayTransformer
implements FieldValueToDisplayTransformer<String> {
    private final I18nHelper i18nBean;
    private final CustomFieldManager customFieldManager;

    public DefaultFieldValueToDisplayTransformer(I18nHelper i18nBean, CustomFieldManager customFieldManager) {
        this.i18nBean = i18nBean;
        this.customFieldManager = customFieldManager;
    }

    @Override
    public String transformFromIrrelevant(String fieldType, Object input, String url) {
        return this.i18nBean.getText("common.concepts.irrelevant");
    }

    @Override
    public String transformFromProject(String fieldType, Object input, String url) {
        return TextUtils.htmlEncode((String)((GenericValue)input).getString("name"));
    }

    @Override
    public String transformFromAssignee(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("gadget.filterstats.assignee.unassigned");
        }
        return TextUtils.htmlEncode((String)((User)input).getDisplayName().trim());
    }

    @Override
    public String transformFromReporter(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("gadget.filterstats.reporter.unknown");
        }
        return TextUtils.htmlEncode((String)((User)input).getDisplayName().trim());
    }

    @Override
    public String transformFromResolution(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("common.resolution.unresolved");
        }
        return TextUtils.htmlEncode((String)((IssueConstant)input).getNameTranslation().trim());
    }

    @Override
    public String transformFromPriority(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("gadget.filterstats.priority.nopriority");
        }
        return TextUtils.htmlEncode((String)((IssueConstant)input).getNameTranslation().trim());
    }

    @Override
    public String transformFromIssueType(String fieldType, Object input, String url) {
        return TextUtils.htmlEncode((String)((IssueConstant)input).getNameTranslation());
    }

    @Override
    public String transformFromStatus(String fieldType, Object input, String url) {
        return TextUtils.htmlEncode((String)((IssueConstant)input).getNameTranslation());
    }

    @Override
    public String transformFromComponent(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("gadget.filterstats.component.nocomponent");
        }
        return TextUtils.htmlEncode((String)((GenericValue)input).getString("name").trim());
    }

    @Override
    public String transformFromVersion(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("gadget.filterstats.raisedin.unscheduled");
        }
        return TextUtils.htmlEncode((String)((Version)input).getName().trim());
    }

    @Override
    public String transformFromFixFor(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("gadget.filterstats.fixfor.unscheduled");
        }
        return TextUtils.htmlEncode((String)((Version)input).getName().trim());
    }

    @Override
    public String transformFromLabels(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("gadget.filterstats.labels.none");
        }
        return TextUtils.htmlEncode((String)((Label)input).getLabel().trim());
    }

    @Override
    public String transformFromCustomField(String fieldType, Object input, String url) {
        if (input == null) {
            return this.i18nBean.getText("common.words.none");
        }
        CustomField customFieldObject = this.customFieldManager.getCustomFieldObject(fieldType);
        return customFieldObject.getCustomFieldSearcher().getDescriptor().getStatHtml(customFieldObject, input, null).trim();
    }
}

