/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StatusJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String statusColor;
    @JsonProperty
    private String description;
    @JsonProperty
    private String iconUrl;
    @JsonProperty
    private String name;
    @JsonProperty
    private String id;

    public StatusJsonBean() {
    }

    public StatusJsonBean(String self, String statusColor, String description, String iconUrl, String name, String id) {
        this.self = self;
        this.statusColor = statusColor;
        this.description = description;
        this.iconUrl = iconUrl;
        this.name = name;
        this.id = id;
    }

    public String self() {
        return this.self;
    }

    public StatusJsonBean self(String self) {
        return new StatusJsonBean(self, this.statusColor, this.description, this.iconUrl, this.name, this.id);
    }

    public String statusColor() {
        return this.statusColor;
    }

    public StatusJsonBean statusColor(String statusColor) {
        return new StatusJsonBean(this.self, statusColor, this.description, this.iconUrl, this.name, this.id);
    }

    public String description() {
        return this.description;
    }

    public StatusJsonBean description(String description) {
        return new StatusJsonBean(this.self, this.statusColor, description, this.iconUrl, this.name, this.id);
    }

    public String iconUrl() {
        return this.iconUrl;
    }

    public StatusJsonBean iconUrl(String iconUrl) {
        return new StatusJsonBean(this.self, this.statusColor, this.description, iconUrl, this.name, this.id);
    }

    public String name() {
        return this.name;
    }

    public StatusJsonBean name(String name) {
        return new StatusJsonBean(this.self, this.statusColor, this.description, this.iconUrl, name, this.id);
    }

    public String id() {
        return this.id;
    }

    public StatusJsonBean id(String id) {
        return new StatusJsonBean(this.self, this.statusColor, this.description, this.iconUrl, this.name, id);
    }

    public static StatusJsonBean bean(Status status, JiraBaseUrls urls) {
        String absoluteIconUrl;
        if (status == null) {
            return null;
        }
        try {
            absoluteIconUrl = new URL(status.getIconUrl()).toString();
        }
        catch (MalformedURLException e) {
            absoluteIconUrl = urls.baseUrl() + status.getIconUrl();
        }
        return new StatusJsonBean().self(urls.restApi2BaseUrl() + "status/" + JiraUrlCodec.encode(status.getId())).name(status.getNameTranslation()).id(status.getId()).iconUrl(absoluteIconUrl).description(status.getDescTranslation());
    }

    public static Collection<StatusJsonBean> beans(Collection<Status> allowedValues, JiraBaseUrls baseUrls) {
        ArrayList result = Lists.newArrayListWithCapacity((int)allowedValues.size());
        for (Status from : allowedValues) {
            result.add(StatusJsonBean.bean(from, baseUrls));
        }
        return result;
    }

    public static StatusJsonBean bean(String id, String name, String self, String iconUrl, String description) {
        return new StatusJsonBean().self(self).description(description).iconUrl(iconUrl).name(name).id(id);
    }
}

