/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.util.MapUtils;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class FieldConfigSchemeImpl
implements FieldConfigScheme {
    private static final Logger log = Logger.getLogger(FieldConfigSchemeImpl.class);
    private final Long id;
    private final String name;
    private final String description;
    private final String fieldId;
    private final Map<String, FieldConfig> configs;
    private final FieldConfigContextPersister configContextPersister;
    private final ResettableLazyReference<List<JiraContextNode>> applicableContexts = new ResettableLazyReference<List<JiraContextNode>>(){

        protected List<JiraContextNode> create() {
            if (FieldConfigSchemeImpl.this.configContextPersister == null) {
                return Collections.emptyList();
            }
            ArrayList<JiraContextNode> applicableContexts = new ArrayList<JiraContextNode>(FieldConfigSchemeImpl.this.configContextPersister.getAllContextsForConfigScheme(FieldConfigSchemeImpl.this));
            Collections.sort(applicableContexts);
            return Collections.unmodifiableList(applicableContexts);
        }
    };
    private final LazyReference<MultiMap> configsByConfig = new LazyReference<MultiMap>(){

        protected MultiMap create() {
            return MapUtils.invertMap(FieldConfigSchemeImpl.this.getConfigs());
        }
    };

    public FieldConfigSchemeImpl(Long id, String fieldId, String name, String description, Map<String, FieldConfig> configs, FieldConfigContextPersister configContextPersister) {
        this.id = id;
        this.fieldId = fieldId;
        this.name = StringUtils.abbreviate((String)name, (int)254);
        this.description = description;
        this.configs = configs != null ? CollectionUtil.copyAsImmutableMap(configs) : Collections.emptyMap();
        this.configContextPersister = configContextPersister;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Map<String, FieldConfig> getConfigs() {
        return this.configs;
    }

    @Override
    public List<JiraContextNode> getContexts() {
        return (List)this.applicableContexts.get();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    String getFieldId() {
        return this.fieldId;
    }

    @Override
    public ConfigurableField getField() {
        return ComponentAccessor.getFieldManager().getConfigurableField(this.fieldId);
    }

    @Override
    public boolean isInContext(IssueContext issueContext) {
        List<JiraContextNode> contexts = this.getContexts();
        if (contexts != null) {
            for (JiraContextNode contextNode : contexts) {
                if (!contextNode.isInContext(issueContext)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<GenericValue> getAssociatedProjectCategories() {
        if (this.isEnabled()) {
            LinkedList<GenericValue> list = new LinkedList<GenericValue>();
            for (JiraContextNode contextNode : this.getContexts()) {
                if (contextNode.getProjectCategory() == null || contextNode.getProjectObject() != null) continue;
                list.add(contextNode.getProjectCategory());
            }
            return list.isEmpty() ? null : list;
        }
        return null;
    }

    @Override
    public List<ProjectCategory> getAssociatedProjectCategoryObjects() {
        if (this.isEnabled()) {
            LinkedList<ProjectCategory> list = new LinkedList<ProjectCategory>();
            for (JiraContextNode contextNode : this.getContexts()) {
                if (contextNode.getProjectCategoryObject() == null || contextNode.getProjectObject() != null) continue;
                list.add(contextNode.getProjectCategoryObject());
            }
            return list.isEmpty() ? null : list;
        }
        return null;
    }

    @Override
    public List<GenericValue> getAssociatedProjects() {
        if (this.isEnabled()) {
            LinkedList<GenericValue> list = new LinkedList<GenericValue>();
            for (JiraContextNode contextNode : this.getContexts()) {
                if (contextNode.getProject() == null) continue;
                list.add(contextNode.getProject());
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Project> getAssociatedProjectObjects() {
        if (this.isEnabled()) {
            LinkedList<Project> list = new LinkedList<Project>();
            for (JiraContextNode contextNode : this.getContexts()) {
                Project projectObject = contextNode.getProjectObject();
                if (projectObject == null) continue;
                list.add(projectObject);
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public Set<GenericValue> getAssociatedIssueTypes() {
        HashSet<GenericValue> associatedIssueTypes = null;
        if (this.isEnabled() && this.getConfigs() != null && !this.getConfigs().isEmpty()) {
            associatedIssueTypes = new HashSet<GenericValue>();
            ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
            for (String issueTypeId : this.getConfigs().keySet()) {
                associatedIssueTypes.add(constantsManager.getIssueType(issueTypeId));
            }
        }
        return associatedIssueTypes;
    }

    @Override
    public boolean isGlobal() {
        return this.isAllProjects() && this.isAllIssueTypes();
    }

    @Override
    public boolean isAllProjects() {
        if (this.isEnabled()) {
            for (JiraContextNode contextNode : this.getContexts()) {
                if (contextNode.getProjectCategoryObject() != null || contextNode.getProjectObject() != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAllIssueTypes() {
        Set<GenericValue> issueTypes = this.getAssociatedIssueTypes();
        return issueTypes != null && issueTypes.contains(null);
    }

    @Override
    public boolean isEnabled() {
        return !this.getContexts().isEmpty();
    }

    @Override
    public boolean isBasicMode() {
        MultiMap configsByConfig = this.getConfigsByConfig();
        return configsByConfig == null || configsByConfig.size() <= 1;
    }

    @Override
    public MultiMap getConfigsByConfig() {
        return (MultiMap)this.configsByConfig.get();
    }

    @Override
    public FieldConfig getOneAndOnlyConfig() {
        MultiMap configsByConfig = this.getConfigsByConfig();
        if (configsByConfig != null && configsByConfig.size() == 1) {
            return (FieldConfig)configsByConfig.keySet().iterator().next();
        }
        if (configsByConfig != null) {
            log.warn((Object)("There is not exactly one config for this scheme (" + this.getId() + "). Configs are " + configsByConfig + "."));
        }
        return null;
    }

    FieldConfigContextPersister getFieldConfigContextPersister() {
        return this.configContextPersister;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FieldConfigScheme)) {
            return false;
        }
        FieldConfigScheme rhs = (FieldConfigScheme)o;
        return new EqualsBuilder().append((Object)this.getId(), (Object)rhs.getId()).append((Object)this.getName(), (Object)rhs.getName()).append((Object)this.getDescription(), (Object)rhs.getDescription()).isEquals();
    }

    public int compareTo(Object obj) {
        FieldConfigScheme o = (FieldConfigScheme)obj;
        return new CompareToBuilder().append((Object)this.getId(), (Object)o.getId()).append((Object)this.getName(), (Object)o.getName()).append((Object)this.getDescription(), (Object)o.getDescription()).toComparison();
    }

    public int hashCode() {
        return new HashCodeBuilder(77, 147).append((Object)this.getId()).append((Object)this.getName()).append((Object)this.getDescription()).toHashCode();
    }
}

