/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.util.JiraKeyUtilsBean;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class JiraWebInterfaceManager {
    public static final String CONTEXT_KEY_USER = "user";
    public static final String CONTEXT_KEY_USERNAME = "username";
    public static final String CONTEXT_KEY_HELPER = "helper";
    public static final String CONTEXT_KEY_LOCATION = "location";
    public static final String CONTEXT_KEY_I18N = "i18n";
    private static final String PARAM_HIGHTLIGHT = "highlight";
    private static final String PARAM_SELECTED = "selected";
    private static final String PARAM_SELECTED_2 = "selected2";
    private static final String PARAM_SELECTED_3 = "selected3";
    private static final String PARAM_BROWSE_RPOJECT = "browseProject";
    private WebInterfaceManager webInterfaceManager;
    private JiraKeyUtilsBean jiraKeyUtilsBean;

    public JiraWebInterfaceManager(WebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
        this.jiraKeyUtilsBean = new JiraKeyUtilsBean();
    }

    public boolean hasSectionsForLocation(String location) {
        return this.webInterfaceManager.hasSectionsForLocation(location);
    }

    public List getSections(String location) {
        return this.webInterfaceManager.getSections(location);
    }

    public List getDisplayableSections(String location, User remoteUser, JiraHelper jiraHelper) {
        return this.webInterfaceManager.getDisplayableSections(location, this.makeContext(remoteUser, jiraHelper));
    }

    public List getItems(String section) {
        return this.webInterfaceManager.getItems(section);
    }

    public List getDisplayableItems(String section, User remoteUser, JiraHelper jiraHelper) {
        List items = this.webInterfaceManager.getDisplayableItems(section, this.makeContext(remoteUser, jiraHelper));
        HttpServletRequest servletRequest = jiraHelper.getRequest();
        if (servletRequest != null) {
            for (WebItemModuleDescriptor item : items) {
                Map params = item.getParams();
                if (!params.containsKey(PARAM_SELECTED) && !params.containsKey(PARAM_SELECTED_2) && !params.containsKey(PARAM_SELECTED_3)) continue;
                this.highlightItem(servletRequest, params);
            }
        }
        return items;
    }

    private void highlightItem(HttpServletRequest servletRequest, Map<String, String> params) {
        String selected = this.getParamFromMap(params, PARAM_SELECTED);
        String selected2 = this.getParamFromMap(params, PARAM_SELECTED_2);
        String selected3 = this.getParamFromMap(params, PARAM_SELECTED_3);
        String servletPath = servletRequest.getServletPath();
        if (servletPath.startsWith(selected) || servletPath.startsWith(selected2) || servletPath.startsWith(selected3)) {
            params.put(PARAM_HIGHTLIGHT, "true");
            String browseProject = params.get(PARAM_BROWSE_RPOJECT);
            String pathInfo = servletRequest.getPathInfo();
            if (StringUtils.isNotEmpty((String)pathInfo) && !pathInfo.equals("/") && StringUtils.isNotEmpty((String)browseProject) && Boolean.parseBoolean(browseProject)) {
                String proj;
                String string = proj = pathInfo.indexOf("/", 1) == -1 ? pathInfo.substring(1) : pathInfo.substring(1, pathInfo.indexOf("/", 1));
                if (this.jiraKeyUtilsBean.validProjectKey(proj.toUpperCase())) {
                    params.put(PARAM_HIGHTLIGHT, "true");
                } else {
                    params.remove(PARAM_HIGHTLIGHT);
                }
            }
        } else {
            params.remove(PARAM_HIGHTLIGHT);
        }
    }

    private String getParamFromMap(Map params, String key) {
        String value = (String)params.get(key);
        return value == null ? " " : value;
    }

    public void refresh() {
        this.webInterfaceManager.refresh();
    }

    public WebFragmentHelper getWebFragmentHelper() {
        return this.webInterfaceManager.getWebFragmentHelper();
    }

    @VisibleForTesting
    protected Map<String, Object> makeContext(User remoteUser, JiraHelper jiraHelper) {
        Map<String, Object> params = jiraHelper.getContextParams();
        params.put(CONTEXT_KEY_USER, remoteUser);
        params.put(CONTEXT_KEY_HELPER, jiraHelper);
        return params;
    }
}

