/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.util.concurrent.Nullable;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;

public class GroupJsonBeanBuilder {
    private final JiraBaseUrls jiraBaseUrls;
    private String name;

    public GroupJsonBeanBuilder(JiraBaseUrls jiraBaseUrls) {
        this.jiraBaseUrls = jiraBaseUrls;
    }

    public GroupJsonBeanBuilder group(@Nullable Group group) {
        if (group != null) {
            this.name = group.getName();
        }
        return this;
    }

    public GroupJsonBeanBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public GroupJsonBean build() {
        if (this.name == null) {
            return null;
        }
        return new GroupJsonBean(this.name, GroupJsonBeanBuilder.makeSelfUri(this.name, this.jiraBaseUrls));
    }

    public static URI makeSelfUri(String groupName, JiraBaseUrls urls) {
        return URI.create(urls.restApi2BaseUrl() + "group?groupname=" + JiraUrlCodec.encode(groupName));
    }

    public static Collection<GroupJsonBean> buildBeans(Collection<Group> Groups, JiraBaseUrls jiraBaseUrls) {
        ArrayList result = Lists.newArrayListWithCapacity((int)Groups.size());
        for (Group from : Groups) {
            result.add(new GroupJsonBeanBuilder(jiraBaseUrls).group(from).build());
        }
        return result;
    }
}

