/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.annotations.Internal;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

@Internal
public class FieldIndexerUtil {
    private static final int MAX_SORT_LENGTH = 50;

    public static void indexKeywordWithDefault(Document doc, String indexField, String fieldValue, String defaultValue) {
        FieldIndexerUtil.indexKeywordWithDefault(doc, indexField, fieldValue, defaultValue, true);
    }

    public static void indexKeywordWithDefault(Document doc, String indexField, Long aLong, String defaultValue) {
        String value = aLong != null ? aLong.toString() : null;
        FieldIndexerUtil.indexKeywordWithDefault(doc, indexField, value, defaultValue);
    }

    public static void indexKeywordWithDefault(Document doc, String indexField, String fieldValue, String defaultValue, boolean searchable) {
        doc.add((Fieldable)FieldIndexerUtil.getField(indexField, fieldValue, defaultValue, searchable));
    }

    private static Field getField(String indexField, String fieldValue, String defaultValue, boolean searchable) {
        String value = StringUtils.isNotBlank((String)fieldValue) ? fieldValue : defaultValue;
        Field.Index index = searchable ? Field.Index.NOT_ANALYZED_NO_NORMS : Field.Index.NO;
        return new Field(indexField, value, Field.Store.YES, index);
    }

    public static String getValueForSorting(String fieldValue) {
        String trimmed;
        String string = trimmed = fieldValue == null ? null : fieldValue.trim();
        if (!StringUtils.isBlank((String)trimmed)) {
            if (trimmed.length() > 50) {
                return trimmed.substring(0, 50);
            }
            return trimmed;
        }
        return String.valueOf('\ufffd');
    }
}

