/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.preferences;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.util.PropertyUtils;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.HashSet;
import java.util.Set;

public class JiraUserPreferences
implements ExtendedPreferences {
    private Supplier<PropertySet> backingPSSupplier = Suppliers.ofInstance(null);
    private final Set<String> defaultKeys = new HashSet<String>();

    public JiraUserPreferences() {
    }

    public JiraUserPreferences(final ApplicationUser user) {
        if (user != null) {
            this.backingPSSupplier = new Supplier<PropertySet>(){

                public PropertySet get() {
                    return ComponentAccessor.getUserPropertyManager().getPropertySet(user);
                }
            };
        }
    }

    public JiraUserPreferences(final User pUser) {
        if (pUser != null) {
            this.backingPSSupplier = new Supplier<PropertySet>(){

                public PropertySet get() {
                    return ComponentAccessor.getUserPropertyManager().getPropertySet(pUser);
                }
            };
        }
    }

    public JiraUserPreferences(PropertySet userPs) {
        if (userPs != null) {
            this.backingPSSupplier = Suppliers.ofInstance((Object)userPs);
        }
    }

    public long getLong(String key) {
        if (this.defaultKeys.contains(key)) {
            return Long.parseLong(this.getApplicationProperties().getDefaultBackedString(key));
        }
        PropertySet backingPS = (PropertySet)this.backingPSSupplier.get();
        if (backingPS != null && backingPS.exists(key)) {
            return backingPS.getLong(key);
        }
        this.defaultKeys.add(key);
        return Long.parseLong(this.getApplicationProperties().getDefaultBackedString(key));
    }

    public String getString(String key) {
        if (this.defaultKeys.contains(key)) {
            return this.getApplicationProperties().getDefaultBackedString(key);
        }
        PropertySet backingPS = (PropertySet)this.backingPSSupplier.get();
        if (backingPS != null && backingPS.exists(key)) {
            return backingPS.getString(key);
        }
        this.defaultKeys.add(key);
        return this.getApplicationProperties().getDefaultBackedString(key);
    }

    @Override
    public String getText(String key) {
        if (this.defaultKeys.contains(key)) {
            return this.getApplicationProperties().getDefaultBackedText(key);
        }
        PropertySet backingPS = (PropertySet)this.backingPSSupplier.get();
        if (backingPS != null && backingPS.exists(key)) {
            return backingPS.getText(key);
        }
        this.defaultKeys.add(key);
        return this.getApplicationProperties().getDefaultBackedText(key);
    }

    public boolean getBoolean(String key) {
        if (this.defaultKeys.contains(key)) {
            return this.getApplicationProperties().getOption(key);
        }
        PropertySet backingPS = (PropertySet)this.backingPSSupplier.get();
        if (backingPS != null && backingPS.exists(key)) {
            return backingPS.getBoolean(key);
        }
        this.defaultKeys.add(key);
        return this.getApplicationProperties().getOption(key);
    }

    public void setLong(String key, long i) throws AtlassianCoreException {
        PropertySet backingPS = (PropertySet)this.backingPSSupplier.get();
        if (backingPS == null) {
            throw new AtlassianCoreException("Trying to set a property on a null user this is not allowed");
        }
        this.defaultKeys.remove(key);
        backingPS.setLong(key, i);
    }

    public void setString(String key, String value) throws AtlassianCoreException {
        PropertySet backingPS = (PropertySet)this.backingPSSupplier.get();
        if (backingPS == null) {
            throw new AtlassianCoreException("Trying to set a property on a null user this is not allowed");
        }
        this.defaultKeys.remove(key);
        backingPS.setString(key, value);
    }

    @Override
    public void setText(String key, String value) throws AtlassianCoreException {
        PropertySet backingPS = (PropertySet)this.backingPSSupplier.get();
        if (backingPS == null) {
            throw new AtlassianCoreException("Trying to set a property on a null user this is not allowed");
        }
        this.defaultKeys.remove(key);
        backingPS.setText(key, value);
    }

    public void setBoolean(String key, boolean b) throws AtlassianCoreException {
        PropertySet backingPS = (PropertySet)this.backingPSSupplier.get();
        if (backingPS == null) {
            throw new AtlassianCoreException("Trying to set a property on a null user this is not allowed");
        }
        this.defaultKeys.remove(key);
        backingPS.setBoolean(key, b);
    }

    public void remove(String key) throws AtlassianCoreException {
        PropertySet backingPS = (PropertySet)this.backingPSSupplier.get();
        if (backingPS == null) {
            throw new AtlassianCoreException("Trying to remove a property on a null user this is not allowed");
        }
        if (!backingPS.exists(key)) {
            throw new AtlassianCoreException("The property with key '" + key + "' does not exist.");
        }
        this.defaultKeys.remove(key);
        backingPS.remove(key);
    }

    ApplicationProperties getApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JiraUserPreferences)) {
            return false;
        }
        JiraUserPreferences jiraUserPreferences = (JiraUserPreferences)o;
        PropertySet backingPS = (PropertySet)this.backingPSSupplier.get();
        if (backingPS == null) {
            return jiraUserPreferences.backingPSSupplier.get() == null;
        }
        return PropertyUtils.identical((PropertySet)backingPS, (PropertySet)((PropertySet)jiraUserPreferences.backingPSSupplier.get()));
    }

    public int hashCode() {
        PropertySet backingPS = (PropertySet)this.backingPSSupplier.get();
        return backingPS != null ? backingPS.hashCode() : 0;
    }

    public boolean containsValue(String key) {
        return ((PropertySet)this.backingPSSupplier.get()).exists(key);
    }
}

