/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.context.AbstractJiraContext;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.ProjectCategoryContext;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

@PublicApi
public class ProjectContext
extends AbstractJiraContext {
    protected Long projectCategory;
    protected Long projectId;
    private final JiraContextTreeManager treeManager;

    public ProjectContext(Long projectId) {
        this.projectId = projectId;
        this.treeManager = ComponentAccessor.getComponent(JiraContextTreeManager.class);
    }

    public ProjectContext(GenericValue project, JiraContextTreeManager treeManager) {
        this.projectId = project != null ? project.getLong("id") : null;
        this.treeManager = treeManager != null ? treeManager : ComponentAccessor.getComponent(JiraContextTreeManager.class);
    }

    public ProjectContext(Project project, JiraContextTreeManager treeManager) {
        this.projectId = project == null ? null : project.getId();
        this.treeManager = treeManager != null ? treeManager : ComponentAccessor.getComponent(JiraContextTreeManager.class);
    }

    public ProjectContext(IssueContext issueContext, JiraContextTreeManager treeManager) {
        this(issueContext.getProjectObject(), treeManager);
    }

    public BandanaContext getParentContext() {
        return new ProjectCategoryContext(this.getProjectCategoryObject(), this.treeManager);
    }

    public boolean hasParentContext() {
        return true;
    }

    @Override
    public Map<String, Object> appendToParamsMap(Map<String, Object> input) {
        return MapBuilder.newBuilder(input).add("project", this.getProjectObject() != null ? this.getProjectObject().getId() : null).toMap();
    }

    @Override
    public Project getProjectObject() {
        if (this.projectId == null) {
            return null;
        }
        return this.treeManager.getProjectManager().getProjectObj(this.projectId);
    }

    @Override
    public GenericValue getProject() {
        return this.projectId != null ? this.treeManager.getProjectManager().getProject(this.projectId) : null;
    }

    @Override
    public GenericValue getProjectCategory() {
        if (this.projectCategory == null && this.projectId != null) {
            GenericValue projectCategoryGv = this.treeManager.getProjectManager().getProjectCategoryFromProject(this.getProject());
            this.projectCategory = projectCategoryGv != null ? projectCategoryGv.getLong("id") : null;
        }
        return this.projectCategory != null ? this.treeManager.getProjectManager().getProjectCategory(this.projectCategory) : null;
    }

    @Override
    public ProjectCategory getProjectCategoryObject() {
        if (this.projectCategory == null && this.projectId != null) {
            ProjectCategory projectCategoryObj = this.treeManager.getProjectManager().getProjectCategoryForProject(this.getProjectObject());
            this.projectCategory = projectCategoryObj != null ? projectCategoryObj.getId() : null;
        }
        return this.projectCategory != null ? this.treeManager.getProjectManager().getProjectCategoryObject(this.projectCategory) : null;
    }

    @Override
    public IssueType getIssueTypeObject() {
        return null;
    }

    @Override
    public GenericValue getIssueType() {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof JiraContextNode)) {
            return false;
        }
        ProjectContext projectContext = (ProjectContext)o;
        return !(this.projectId != null ? !this.projectId.equals(projectContext.projectId) : projectContext.projectId != null);
    }

    @Override
    public int hashCode() {
        int result = 59 * (this.projectId != null ? this.projectId.hashCode() : 0) + 397;
        return result;
    }
}

