/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import org.apache.commons.lang.StringUtils;

@PublicApi
public class SearchRequest
implements SharedEntity {
    public static final SharedEntity.TypeDescriptor<SearchRequest> ENTITY_TYPE = SharedEntity.TypeDescriptor.Factory.get().create("SearchRequest");
    private Long id;
    private String name;
    private String description;
    private Long favouriteCount;
    private String ownerKey;
    private Query query;
    private boolean modified = false;
    private boolean loaded = false;
    private boolean useColumns;
    private SharedEntity.SharePermissions sharePermissions = SharedEntity.SharePermissions.PRIVATE;

    public SearchRequest() {
        this.query = new QueryImpl(null, new OrderByImpl(new SearchSort[0]), null);
        this.setModified(false);
        this.setUseColumns(true);
    }

    public SearchRequest(Query query) {
        this.query = query;
        this.setModified(false);
        this.setUseColumns(true);
    }

    public SearchRequest(SearchRequest oldRequest) {
        this(oldRequest.getQuery(), oldRequest.getOwner(), oldRequest.getName(), oldRequest.getDescription(), oldRequest.getId(), (long)oldRequest.getFavouriteCount());
        this.setUseColumns(oldRequest.useColumns());
        this.setPermissions(oldRequest.getPermissions());
        this.setModified(oldRequest.isModified());
    }

    public SearchRequest(Query query, ApplicationUser owner, String name, String description) {
        this();
        this.ownerKey = ApplicationUsers.getKeyFor(owner);
        this.name = name;
        this.description = description;
        this.query = query;
    }

    public SearchRequest(Query query, ApplicationUser owner, String name, String description, Long id, long favouriteCount) {
        this();
        this.ownerKey = ApplicationUsers.getKeyFor(owner);
        this.name = name;
        this.description = description;
        this.query = query;
        this.id = id;
        this.favouriteCount = favouriteCount;
    }

    public SearchRequest(Query query, String ownerUserName, String name, String description) {
        this(query, ComponentAccessor.getUserManager().getUserByName(ownerUserName), name, description);
    }

    public SearchRequest(Query query, String ownerUserName, String name, String description, Long id, long favouriteCount) {
        this(query, ComponentAccessor.getUserManager().getUserByName(ownerUserName), name, description, id, favouriteCount);
    }

    @NotNull
    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        Assertions.notNull("query", query);
        this.setModified(true);
        this.query = query;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.setModified(true);
        this.name = name;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public SharedEntity.SharePermissions getPermissions() {
        return this.sharePermissions;
    }

    public void setPermissions(SharedEntity.SharePermissions sharePermissions) {
        Assertions.notNull("permissions", sharePermissions);
        this.sharePermissions = sharePermissions;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ApplicationUser getOwner() {
        return ComponentAccessor.getUserManager().getUserByKeyEvenWhenUnknown(this.ownerKey);
    }

    @Override
    public String getOwnerUserName() {
        return ComponentAccessor.getUserKeyService().getUsernameForKey(this.ownerKey);
    }

    public void setDescription(String description) {
        this.setModified(true);
        this.description = description;
    }

    protected void setFavouriteCount(Long favouriteCount) {
        this.setModified(true);
        this.favouriteCount = favouriteCount;
    }

    @Override
    public Long getFavouriteCount() {
        if (this.favouriteCount == null) {
            this.favouriteCount = 0L;
        }
        return this.favouriteCount;
    }

    public void setOwner(ApplicationUser owner) {
        this.setModified(true);
        this.ownerKey = ApplicationUsers.getKeyFor(owner);
    }

    public void setOwnerUserName(String ownerUserName) {
        if (ownerUserName == null) {
            this.setOwner(null);
        } else {
            this.setOwner(ComponentAccessor.getUserManager().getUserByName(ownerUserName));
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isLoaded() {
        return this.id != null;
    }

    public boolean useColumns() {
        return this.useColumns;
    }

    public void setUseColumns(boolean useColumns) {
        this.useColumns = useColumns;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("Search Request: name: ");
        buff.append(this.getName());
        buff.append("\n");
        if (this.query != null && !StringUtils.isBlank((String)this.query.toString())) {
            buff.append("query = ").append(this.query.toString());
        }
        return buff.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchRequest request = (SearchRequest)o;
        if (this.loaded != request.loaded) {
            return false;
        }
        if (this.description != null ? !this.description.equals(request.description) : request.description != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(request.id) : request.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(request.name) : request.name != null) {
            return false;
        }
        if (this.ownerKey != null ? !this.ownerKey.equals(request.ownerKey) : request.ownerKey != null) {
            return false;
        }
        return this.query.equals(request.query);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.ownerKey != null ? this.ownerKey.hashCode() : 0);
        result = 31 * result + this.query.hashCode();
        result = 31 * result + (this.loaded ? 1 : 0);
        return result;
    }

    public final SharedEntity.TypeDescriptor<SearchRequest> getEntityType() {
        return ENTITY_TYPE;
    }
}

