/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.action;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.util.profiling.UtilTimerStack;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericDelegator;
import webwork.action.ActionSupport;
import webwork.action.CommandDriven;
import webwork.dispatcher.ActionResult;
import webwork.util.editor.PropertyEditorException;

@PublicSpi
public abstract class JiraActionSupport
extends ActionSupport
implements CommandDriven,
I18nHelper {
    protected final Logger log = Logger.getLogger(this.getClass());
    private GenericDelegator delegator;
    private OfBizDelegator ofBizDelegator;
    private Preferences userPrefs;
    private I18nHelper i18nHelperDelegate;

    protected JiraActionSupport() {
    }

    public abstract User getLoggedInUser();

    public User getRemoteUser() {
        return this.getLoggedInUser();
    }

    protected <T> T getComponentInstanceOfType(Class<T> clazz) {
        return ComponentAccessor.getComponentOfType(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        String logLine = this.getActionName() + ".execute()";
        UtilTimerStack.push((String)logLine);
        try {
            String string = super.execute();
            return string;
        }
        finally {
            UtilTimerStack.pop((String)logLine);
        }
    }

    public OfBizDelegator getOfBizDelegator() {
        if (this.ofBizDelegator == null) {
            this.ofBizDelegator = ComponentAccessor.getComponent(OfBizDelegator.class);
        }
        return this.ofBizDelegator;
    }

    public GenericDelegator getDelegator() {
        if (this.delegator == null) {
            this.delegator = (GenericDelegator)ComponentAccessor.getComponent(DelegatorInterface.class);
        }
        return this.delegator;
    }

    public ApplicationProperties getApplicationProperties() {
        return this.getComponentInstanceOfType(ApplicationProperties.class);
    }

    public WatcherManager getWatcherManager() {
        return this.getComponentInstanceOfType(WatcherManager.class);
    }

    public final String getActionName() {
        String classname = this.getClass().getName();
        return classname.substring(classname.lastIndexOf(46) + 1);
    }

    public String getResult() {
        return this.invalidInput() ? "error" : "success";
    }

    public void addErrorMessages(Collection<String> errorMessages) {
        if (errorMessages == null) {
            return;
        }
        for (String errorMessage : errorMessages) {
            this.addErrorMessage(errorMessage);
        }
    }

    public void addErrors(Map<String, String> errors) {
        if (errors == null) {
            return;
        }
        for (Map.Entry<String, String> mapEntry : errors.entrySet()) {
            String name = mapEntry.getKey();
            String error = mapEntry.getValue();
            this.addError(name, error);
        }
    }

    public boolean hasAnyErrors() {
        return !this.getErrors().isEmpty() || !this.getErrorMessages().isEmpty();
    }

    public void addErrorMessages(ActionResult aResult) {
        if (!"success".equals(aResult.getResult())) {
            ActionSupport actionSupport = (ActionSupport)aResult.getFirstAction();
            this.addErrorMessages(actionSupport.getErrorMessages());
        }
    }

    public boolean isIndexing() {
        return this.getApplicationProperties().getOption("jira.option.indexing");
    }

    public void addIllegalArgumentException(String fieldName, IllegalArgumentException e) {
        String msg = e.getMessage();
        if (e instanceof PropertyEditorException) {
            msg = this.getPropertyEditorMessage(fieldName, (PropertyEditorException)e);
        }
        if (msg == null || !msg.startsWith("missing matching end quote")) {
            this.addError(fieldName, msg);
        }
    }

    public Preferences getUserPreferences() {
        if (this.userPrefs == null) {
            this.userPrefs = this.getComponentInstanceOfType(UserPreferencesManager.class).getPreferences(this.getLoggedInUser());
        }
        return this.userPrefs;
    }

    protected void removeKeyOrAddError(Map params, String key, String messageKey) {
        if (params.containsKey(key)) {
            params.remove(key);
        } else {
            this.addErrorMessage(this.getText(messageKey));
        }
    }

    protected I18nHelper getI18nHelper() {
        if (this.i18nHelperDelegate == null) {
            this.i18nHelperDelegate = this.getComponentInstanceOfType(JiraAuthenticationContext.class).getI18nHelper();
        }
        return this.i18nHelperDelegate;
    }

    @Override
    public Set<String> getKeysForPrefix(String prefix) {
        throw new UnsupportedOperationException("This method should only be called via the I18nBean and is only required for SAL.");
    }

    @Override
    public ResourceBundle getDefaultResourceBundle() {
        return this.getI18nHelper().getDefaultResourceBundle();
    }

    @Override
    public Locale getLocale() {
        return this.getI18nHelper().getLocale();
    }

    @Override
    public String getUnescapedText(String key) {
        return this.getI18nHelper().getUnescapedText(key);
    }

    @Override
    public String getUntransformedRawText(String key) {
        return this.getI18nHelper().getUntransformedRawText(key);
    }

    @Override
    public boolean isKeyDefined(String key) {
        return this.getI18nHelper().isKeyDefined(key);
    }

    @Override
    @HtmlSafe
    public String getText(String key) {
        return this.getI18nHelper().getText(key);
    }

    @Override
    @HtmlSafe
    public String getText(String key, String value1) {
        return this.getI18nHelper().getText(key, value1);
    }

    @Override
    @HtmlSafe
    public String getText(String key, String value1, String value2) {
        return this.getI18nHelper().getText(key, value1, value2);
    }

    @Override
    @HtmlSafe
    public String getText(String key, String value1, String value2, String value3) {
        return this.getI18nHelper().getText(key, value1, value2, value3);
    }

    @Override
    @HtmlSafe
    public String getText(String key, String value1, String value2, String value3, String value4) {
        return this.getI18nHelper().getText(key, value1, value2, value3, value4);
    }

    @Override
    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3) {
        return this.getI18nHelper().getText(key, value1, value2, value3);
    }

    @Override
    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3, Object value4) {
        return this.getI18nHelper().getText(key, value1, value2, value3, value4);
    }

    @Override
    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5) {
        return this.getI18nHelper().getText(key, value1, value2, value3, value4, value5);
    }

    @Override
    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6) {
        return this.getI18nHelper().getText(key, value1, value2, value3, value4, value5, value6);
    }

    @Override
    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7) {
        return this.getI18nHelper().getText(key, value1, value2, value3, value4, value5, value6, value7);
    }

    @Override
    @HtmlSafe
    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7) {
        return this.getI18nHelper().getText(key, value1, value2, value3, value4, value5, value6, value7);
    }

    @Override
    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7, Object value8) {
        return this.getI18nHelper().getText(key, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    @Override
    @HtmlSafe
    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7, String value8, String value9) {
        return this.getI18nHelper().getText(key, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    @Override
    @HtmlSafe
    public String getText(String key, Object parameters) {
        return this.getI18nHelper().getText(key, parameters);
    }
}

