/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.NotNull;
import com.atlassian.util.concurrent.Nullable;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;

public interface UserUtil {
    public static final String META_PROPERTY_PREFIX = "jira.meta.";

    public int getTotalUserCount();

    @NotNull
    public Set<User> getAllUsers();

    @NotNull
    public Collection<User> getUsers();

    public Group getGroup(@Nullable String var1);

    public Group getGroupObject(@Nullable String var1);

    public User createUserWithNotification(String var1, String var2, String var3, String var4, int var5) throws PermissionException, CreateException;

    public User createUserWithNotification(String var1, String var2, String var3, String var4, Long var5, int var6) throws PermissionException, CreateException;

    public User createUserNoNotification(String var1, String var2, String var3, String var4) throws PermissionException, CreateException;

    public User createUserNoNotification(String var1, String var2, String var3, String var4, Long var5) throws PermissionException, CreateException;

    public void removeUser(User var1, User var2);

    public void addUserToGroup(Group var1, User var2) throws PermissionException, AddException;

    public void addUserToGroups(Collection<Group> var1, User var2) throws PermissionException, AddException;

    public void removeUserFromGroup(Group var1, User var2) throws PermissionException, RemoveException;

    public void removeUserFromGroups(Collection<Group> var1, User var2) throws PermissionException, RemoveException;

    public PasswordResetToken generatePasswordResetToken(User var1);

    public PasswordResetTokenValidation validatePasswordResetToken(User var1, String var2);

    public void changePassword(User var1, String var2) throws UserNotFoundException, InvalidCredentialException, OperationNotPermittedException, PermissionException;

    public int getActiveUserCount();

    public void clearActiveUserCount();

    public boolean hasExceededUserLimit();

    public boolean canActivateNumberOfUsers(int var1);

    public boolean canActivateUsers(Collection<String> var1);

    public User getUser(String var1);

    public User getUserObject(String var1);

    public boolean userExists(String var1);

    public Collection<User> getAdministrators();

    public Collection<User> getJiraAdministrators();

    public Collection<User> getSystemAdministrators();

    public Collection<User> getJiraSystemAdministrators();

    public void addToJiraUsePermission(User var1) throws PermissionException;

    public Collection<ProjectComponent> getComponentsUserLeads(User var1);

    public Collection<Project> getProjectsLeadBy(User var1);

    public boolean isNonSysAdminAttemptingToDeleteSysAdmin(User var1, User var2);

    public long getNumberOfReportedIssuesIgnoreSecurity(User var1, User var2) throws SearchException;

    public long getNumberOfAssignedIssuesIgnoreSecurity(User var1, User var2) throws SearchException;

    public String getDisplayableNameSafely(User var1);

    public SortedSet<Group> getGroupsForUser(String var1);

    public SortedSet<String> getGroupNamesForUser(String var1);

    public SortedSet<User> getAllUsersInGroupNames(Collection<String> var1);

    public Set<User> getAllUsersInGroupNamesUnsorted(Collection<String> var1);

    public SortedSet<User> getUsersInGroupNames(Collection<String> var1);

    public SortedSet<User> getAllUsersInGroups(Collection<Group> var1);

    public SortedSet<User> getUsersInGroups(Collection<Group> var1);

    public static interface PasswordResetTokenValidation {
        public Status getStatus();

        public static enum Status {
            EXPIRED,
            UNEQUAL,
            OK;

        }
    }

    public static interface PasswordResetToken {
        public User getUser();

        public String getToken();

        public int getExpiryHours();

        public long getExpiryTime();
    }
}

