/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.codehaus.jackson.annotate.JsonProperty;

public class SecurityLevelJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String id;
    @JsonProperty
    private String description;
    @JsonProperty
    private String name;

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static Collection<SecurityLevelJsonBean> shortBeans(Collection<IssueSecurityLevel> securitylevels, JiraBaseUrls urls) {
        ArrayList result = Lists.newArrayListWithCapacity((int)securitylevels.size());
        for (IssueSecurityLevel from : securitylevels) {
            result.add(SecurityLevelJsonBean.shortBean(from, urls));
        }
        return result;
    }

    public static SecurityLevelJsonBean shortBean(IssueSecurityLevel securityLevel, JiraBaseUrls urls) {
        if (securityLevel == null) {
            return null;
        }
        SecurityLevelJsonBean bean = new SecurityLevelJsonBean();
        bean.self = urls.restApi2BaseUrl() + "securitylevel/" + JiraUrlCodec.encode(securityLevel.getId().toString());
        bean.id = securityLevel.getId().toString();
        bean.description = securityLevel.getDescription();
        bean.name = securityLevel.getName();
        return bean;
    }
}

