/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AttachmentJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String id;
    @JsonProperty
    private String filename;
    @JsonProperty
    private UserJsonBean author;
    @XmlJavaTypeAdapter(value=Dates.DateTimeAdapter.class)
    private Date created;
    @JsonProperty
    private long size;
    @JsonProperty
    private String mimeType;
    @JsonProperty
    private String content;
    @JsonProperty
    private String thumbnail;

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public UserJsonBean getAuthor() {
        return this.author;
    }

    public void setAuthor(UserJsonBean author) {
        this.author = author;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public static Collection<AttachmentJsonBean> shortBeans(Collection<Attachment> attachments, final JiraBaseUrls urls, final ThumbnailManager thumbnailManager) {
        return Collections2.transform(attachments, (Function)new Function<Attachment, AttachmentJsonBean>(){

            public AttachmentJsonBean apply(Attachment from) {
                return AttachmentJsonBean.shortBean(from, urls, thumbnailManager);
            }
        });
    }

    public static AttachmentJsonBean shortBean(Attachment attachment, JiraBaseUrls urls, ThumbnailManager thumbnailManager) {
        AttachmentJsonBean bean;
        if (attachment == null) {
            return null;
        }
        try {
            bean = new AttachmentJsonBean();
            bean.self = urls.restApi2BaseUrl() + "attachment/" + JiraUrlCodec.encode(attachment.getId().toString());
            bean.id = attachment.getId().toString();
            bean.filename = attachment.getFilename();
            bean.size = attachment.getFilesize();
            bean.mimeType = attachment.getMimetype();
            User author = UserUtils.getUserEvenWhenUnknown(attachment.getAuthor());
            bean.author = UserJsonBean.shortBean(author, urls);
            bean.content = attachment.getFilename();
            bean.created = attachment.getCreated();
            String encodedFilename = URLEncoder.encode(attachment.getFilename(), "UTF-8");
            bean.content = String.format("%s/secure/attachment/%s/%s", urls.baseUrl(), attachment.getId(), encodedFilename);
            Thumbnail thumbnail = thumbnailManager.getThumbnail(attachment.getIssueObject(), attachment);
            if (thumbnail != null) {
                bean.thumbnail = AttachmentJsonBean.getThumbnailURL(urls, thumbnail, attachment.getId());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error encoding file name", e);
        }
        return bean;
    }

    private static String getThumbnailURL(JiraBaseUrls urls, Thumbnail thumbnail, Long id) throws UnsupportedEncodingException {
        String thumbnailURL;
        if (thumbnail != null) {
            String encodedThumbnailFilename = URLEncoder.encode(thumbnail.getFilename(), "UTF-8");
            thumbnailURL = String.format("%s/secure/thumbnail/%s/%s", urls.baseUrl(), id, encodedThumbnailFilename);
        } else {
            thumbnailURL = null;
        }
        return thumbnailURL;
    }
}

