/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.annotations.Internal;
import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.util.DateSearcherConfig;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.action.util.CalendarLanguageUtil;
import com.atlassian.jira.web.action.util.CalendarResourceIncluder;
import com.atlassian.query.Query;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import webwork.action.Action;

@Internal
public abstract class AbstractDateSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    private static final Logger log = Logger.getLogger(AbstractDateSearchRenderer.class);
    private final CalendarLanguageUtil calendarUtils;
    private final DateSearcherConfig config;
    private final TranslationsHelper translationHelper;
    private final SimpleFieldSearchConstants constants;

    public AbstractDateSearchRenderer(SimpleFieldSearchConstants constants, DateSearcherConfig config, TranslationsHelper translationHelper, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, String searcherNameKey, CalendarLanguageUtil calendarUtils) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, constants, searcherNameKey);
        this.constants = Assertions.notNull("constants", constants);
        this.config = Assertions.notNull("config", config);
        this.calendarUtils = Assertions.notNull("calendarUtils", calendarUtils);
        this.translationHelper = Assertions.notNull("translationHelper", translationHelper);
    }

    @Override
    public abstract boolean isShown(User var1, SearchContext var2);

    @Override
    public String getEditHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        return this.renderEditTemplate("date-searcher-edit.vm", this.addEditParameters(user, velocityParams));
    }

    private Map<String, Object> addEditParameters(User searcher, Map<String, Object> velocityParams) {
        I18nHelper i18n = this.getI18n(searcher);
        String language = i18n.getLocale().getLanguage();
        velocityParams.put("hasCalendarTranslation", this.calendarUtils.hasTranslationForLanguage(language));
        velocityParams.put("calendarIncluder", new CalendarResourceIncluder());
        velocityParams.put("fieldName", this.config.getFieldName());
        return this.addCommonParameters(searcher, velocityParams);
    }

    @Override
    public String getViewHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        return this.renderViewTemplate("date-searcher-view.vm", this.addViewParameters(user, velocityParams, fieldValuesHolder));
    }

    private Map<String, Object> addViewParameters(User searcher, Map<String, Object> velocityParams, FieldValuesHolder fieldValuesHolder) {
        Object nextFieldValue;
        Object previousFieldValue = fieldValuesHolder.get(this.config.getPreviousField());
        if (previousFieldValue != null) {
            Long previousOffSet = this.getPeriodOffset(fieldValuesHolder, this.config.getPreviousField());
            if (previousOffSet != null) {
                velocityParams.put("previousFieldView", this.prettyPrintPeriodOffset(this.getI18n(searcher), previousOffSet));
            } else if (this.isKickass()) {
                String prevFieldStr = (String)previousFieldValue;
                if (prevFieldStr.startsWith("-")) {
                    prevFieldStr = prevFieldStr.substring(1);
                }
                velocityParams.put("previousFieldView", StringEscapeUtils.escapeJava((String)prevFieldStr));
            }
        }
        if ((nextFieldValue = fieldValuesHolder.get(this.config.getNextField())) != null) {
            Long nextOffSet = this.getPeriodOffset(fieldValuesHolder, this.config.getNextField());
            if (nextOffSet != null) {
                velocityParams.put("nextFieldView", this.prettyPrintPeriodOffset(this.getI18n(searcher), nextOffSet));
            } else if (this.isKickass()) {
                String nextFieldStr = ((String)nextFieldValue).substring(1);
                velocityParams.put("nextFieldView", StringEscapeUtils.escapeJava((String)nextFieldStr));
            }
        }
        return this.addCommonParameters(searcher, velocityParams);
    }

    private Map<String, Object> addCommonParameters(User searcher, Map<String, Object> velocityParams) {
        velocityParams.put("afterField", this.config.getAfterField());
        velocityParams.put("beforeField", this.config.getBeforeField());
        velocityParams.put("previousField", this.config.getPreviousField());
        velocityParams.put("nextField", this.config.getNextField());
        velocityParams.put("id", this.config.getId());
        I18nHelper i18n = this.getI18n(searcher);
        velocityParams.put("afterFieldLabel", this.translationHelper.getAfterLabel(i18n));
        velocityParams.put("beforeFieldLabel", this.translationHelper.getBeforeLabel(i18n));
        velocityParams.put("periodLabel", this.translationHelper.getPeriodLabel(i18n));
        velocityParams.put("description", this.translationHelper.getDescription(i18n));
        return velocityParams;
    }

    @Override
    public boolean isRelevantForQuery(User user, Query query) {
        return this.isRelevantForQuery(this.constants.getJqlClauseNames(), query);
    }

    private String prettyPrintPeriodOffset(I18nHelper i18n, long periodOffSet) {
        String msg = DateUtils.getDurationPretty((long)((long)((double)Math.abs(periodOffSet) / 1000.0)), (ResourceBundle)i18n.getDefaultResourceBundle());
        if (periodOffSet > 0L) {
            return i18n.getText("navigator.hidden.search.request.summary.date.ago", msg);
        }
        if (periodOffSet < 0L) {
            return i18n.getText("navigator.hidden.search.request.summary.date.from.now", msg);
        }
        return i18n.getText("navigator.hidden.search.request.summary.date.now");
    }

    private Long getPeriodOffset(FieldValuesHolder fieldValuesHolder, String paramField) {
        String periodStr;
        if (fieldValuesHolder.containsKey(paramField) && (periodStr = StringUtils.trimToNull((String)ParameterUtils.getStringParam(fieldValuesHolder, paramField))) != null) {
            try {
                return -DateUtils.getDurationWithNegative((String)periodStr) * DateUtils.SECOND_MILLIS;
            }
            catch (InvalidDurationException e) {
                log.debug((Object)("Could not get duration for: " + periodStr), (Throwable)e);
            }
            catch (NumberFormatException e) {
                log.debug((Object)("Could not get duration for: " + periodStr), (Throwable)e);
            }
        }
        return null;
    }

    public static interface TranslationsHelper {
        public String getBeforeLabel(I18nHelper var1);

        public String getAfterLabel(I18nHelper var1);

        public String getPeriodLabel(I18nHelper var1);

        public String getDescription(I18nHelper var1);
    }
}

