/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HitCollectorUtil {
    private static final Pattern CUSTOM_FIELD_REGEX = Pattern.compile("^customfield_\\d+", 2);

    public String getFieldId(String documentConstant) {
        if (SystemSearchConstants.forComponent().getIndexField().equals(documentConstant)) {
            return SystemSearchConstants.forComponent().getFieldId();
        }
        if (SystemSearchConstants.forAssignee().getIndexField().equals(documentConstant)) {
            return SystemSearchConstants.forAssignee().getFieldId();
        }
        if (SystemSearchConstants.forIssueType().getIndexField().equals(documentConstant)) {
            return SystemSearchConstants.forIssueType().getFieldId();
        }
        if (SystemSearchConstants.forFixForVersion().getIndexField().equals(documentConstant)) {
            return SystemSearchConstants.forFixForVersion().getFieldId();
        }
        if (SystemSearchConstants.forPriority().getIndexField().equals(documentConstant)) {
            return SystemSearchConstants.forPriority().getFieldId();
        }
        if (SystemSearchConstants.forProject().getIndexField().equals(documentConstant)) {
            return SystemSearchConstants.forProject().getFieldId();
        }
        if (SystemSearchConstants.forAffectedVersion().getIndexField().equals(documentConstant)) {
            return SystemSearchConstants.forAffectedVersion().getFieldId();
        }
        if (SystemSearchConstants.forReporter().getIndexField().equals(documentConstant)) {
            return SystemSearchConstants.forReporter().getFieldId();
        }
        if (SystemSearchConstants.forResolution().getIndexField().equals(documentConstant)) {
            return SystemSearchConstants.forResolution().getFieldId();
        }
        if (SystemSearchConstants.forStatus().getIndexField().equals(documentConstant)) {
            return SystemSearchConstants.forStatus().getFieldId();
        }
        Matcher matcher = CUSTOM_FIELD_REGEX.matcher(documentConstant);
        if (matcher.find()) {
            return matcher.group();
        }
        return documentConstant;
    }
}

