/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import org.codehaus.jackson.annotate.JsonProperty;

public class ResolutionJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String id;
    @JsonProperty
    private String description;
    @JsonProperty
    private String iconUrl;
    @JsonProperty
    private String name;

    public static Collection<ResolutionJsonBean> shortBeans(Collection<Resolution> resolutions, final JiraBaseUrls urls) {
        return Collections2.transform(resolutions, (Function)new Function<Resolution, ResolutionJsonBean>(){

            public ResolutionJsonBean apply(Resolution from) {
                return ResolutionJsonBean.shortBean(from, urls);
            }
        });
    }

    public static ResolutionJsonBean shortBean(Resolution resolution, JiraBaseUrls urls) {
        if (resolution == null) {
            return null;
        }
        ResolutionJsonBean bean = new ResolutionJsonBean();
        bean.self = urls.restApi2BaseUrl() + "resolution/" + JiraUrlCodec.encode(resolution.getId().toString());
        bean.id = resolution.getId();
        bean.name = resolution.getNameTranslation();
        bean.description = resolution.getDescTranslation();
        return bean;
    }
}

