/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ContextSetUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import java.util.Collection;
import java.util.HashSet;

public class IntersectingClauseContextFactory
implements ClauseContextFactory {
    private final ContextSetUtil contextSetUtil;
    private final Collection<ClauseContextFactory> subClauseContextFactories;

    public IntersectingClauseContextFactory(ContextSetUtil contextSetUtil, Collection<ClauseContextFactory> subClauseContextFactories) {
        this.subClauseContextFactories = Assertions.containsNoNulls("subClauseContextFactories", subClauseContextFactories);
        this.contextSetUtil = Assertions.notNull("contextSetUtil", contextSetUtil);
    }

    @Override
    public ClauseContext getClauseContext(User searcher, TerminalClause terminalClause) {
        HashSet<ClauseContext> clauseContexts = new HashSet<ClauseContext>();
        for (ClauseContextFactory subClauseContextFactory : this.subClauseContextFactories) {
            clauseContexts.add(subClauseContextFactory.getClauseContext(searcher, terminalClause));
        }
        return this.contextSetUtil.intersect(clauseContexts);
    }
}

