/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import webwork.action.Action;

public class VersionCustomFieldRenderer
extends CustomFieldRenderer
implements SearchRenderer {
    private final VersionManager versionManager;

    public VersionCustomFieldRenderer(ClauseNames clauseNames, VersionManager versionManager, FieldVisibilityManager fieldVisibilityManager, CustomFieldSearcherModuleDescriptor customFieldSearcherModuleDescriptor, CustomFieldValueProvider customFieldValueProvider, CustomField field) {
        super(clauseNames, customFieldSearcherModuleDescriptor, field, customFieldValueProvider, fieldVisibilityManager);
        this.versionManager = versionManager;
    }

    @Override
    public boolean isShown(User user, SearchContext searchContext) {
        return super.isShown(user, searchContext) && this.isSingleProject(searchContext);
    }

    @Override
    public String getEditHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        if (this.isSingleProject(searchContext)) {
            HashMap<String, Object> velocityParameters = new HashMap<String, Object>();
            Project project = searchContext.getSingleProject();
            Collection<Version> releasedversion = this.versionManager.getVersionsReleasedDesc(project.getId(), false);
            Collection<Version> unreleasedversion = this.versionManager.getVersionsUnreleased(project.getId(), false);
            velocityParameters.put("releasedVersion", releasedversion);
            velocityParameters.put("unreleasedVersion", unreleasedversion);
            velocityParameters.put("multiple", Boolean.TRUE);
            return super.getEditHtml(searchContext, fieldValuesHolder, displayParameters, action, velocityParameters);
        }
        return "";
    }

    private boolean isSingleProject(SearchContext searchContext) {
        return searchContext != null && searchContext.isSingleProjectContext();
    }
}

