/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.action.admin.issuetypes.ManageableOptionType;
import java.util.Collection;
import org.ofbiz.core.entity.GenericValue;

public class IssueTypeManageableOption
implements ManageableOptionType {
    private final ConstantsManager constantsManager;
    private final SubTaskManager subTaskManager;
    private final ApplicationProperties properties;
    private JiraAuthenticationContext authenticationContext;

    public IssueTypeManageableOption(ConstantsManager constantsManager, SubTaskManager subTaskManager, ApplicationProperties properties, JiraAuthenticationContext authenticationContext) {
        this.constantsManager = constantsManager;
        this.subTaskManager = subTaskManager;
        this.properties = properties;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public String getFieldId() {
        return "issuetype";
    }

    @Override
    public String getActionPrefix() {
        return "IssueType";
    }

    @Override
    public String getLocalHelpSuffix() {
        return "IssueTypes";
    }

    @Override
    public String getTitle() {
        return this.authenticationContext.getI18nHelper().getText("admin.issue.type.manageable.option.title");
    }

    @Override
    public String getTitleSingle() {
        return this.authenticationContext.getI18nHelper().getText("admin.issue.type.manageable.option.title.single");
    }

    @Override
    public String getTitleLowerCase() {
        return this.getTitle().toLowerCase();
    }

    @Override
    public boolean isIconEnabled() {
        return true;
    }

    @Override
    public boolean isTypeEnabled() {
        return this.subTaskManager.isSubTasksEnabled();
    }

    @Override
    public Collection getAllOptions() {
        return this.constantsManager.getAllIssueTypeObjects();
    }

    @Override
    public boolean isDefault(GenericValue constant) {
        String constantId = this.properties.getString("jira.constant.default.issue.type");
        return constantId != null && constant.getString("id").equals(constantId);
    }

    public Collection getTypesList() {
        return EasyList.build((Object)new TextOption("", this.authenticationContext.getI18nHelper().getText("admin.issue.type.manageable.option.standard.value"), this.authenticationContext.getI18nHelper().getText("admin.issue.type.manageable.option.standard.desc")), (Object)new TextOption("jira_subtask", this.authenticationContext.getI18nHelper().getText("admin.issue.type.manageable.option.subtask.value"), this.authenticationContext.getI18nHelper().getText("admin.issue.type.manageable.option.subtask.desc")));
    }
}

