/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.constants;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.index.IndexedChangeHistoryFieldManager;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operator.Operator;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@ThreadSafe
public final class SimpleFieldSearchConstants
implements ClauseInformation {
    private final String indexField;
    private final ClauseNames jqlClauseNames;
    private final String urlParameter;
    private final String searcherId;
    private final String fieldId;
    private final Set<Operator> supportedOperators;
    private final JiraDataType supportedType;

    public SimpleFieldSearchConstants(String field, Set<Operator> supportedOperators, JiraDataType supportedType) {
        this(field, field, field, field, field, supportedOperators, supportedType);
    }

    public SimpleFieldSearchConstants(String indexField, ClauseNames names, String urlParameter, String searcherId, String fieldId, Set<Operator> supportedOperators, JiraDataType supportedType) {
        this.supportedType = Assertions.notNull("supportedType", supportedType);
        this.fieldId = Assertions.notBlank("fieldId", fieldId);
        this.indexField = Assertions.notBlank("indexField", indexField);
        this.urlParameter = Assertions.notBlank("urlParameter", urlParameter);
        this.jqlClauseNames = Assertions.notNull("names", names);
        this.searcherId = Assertions.notBlank("searcherId", searcherId);
        this.supportedOperators = Assertions.notNull("supportedOperators", supportedOperators);
    }

    public SimpleFieldSearchConstants(String indexField, String jqlClauseName, String urlParameter, String searcherId, String fieldId, Set<Operator> supportedOperators, JiraDataType supportedType) {
        this(indexField, new ClauseNames(Assertions.notBlank("jqlClauseNames", jqlClauseName)), urlParameter, searcherId, fieldId, supportedOperators, supportedType);
    }

    @Override
    public String getIndexField() {
        return this.indexField;
    }

    @Override
    public ClauseNames getJqlClauseNames() {
        return this.jqlClauseNames;
    }

    public String getUrlParameter() {
        return this.urlParameter;
    }

    public String getSearcherId() {
        return this.searcherId;
    }

    @Override
    public String getFieldId() {
        return this.fieldId;
    }

    @Override
    public Set<Operator> getSupportedOperators() {
        IndexedChangeHistoryFieldManager indexedChangeHistoryFieldManager = ComponentAccessor.getComponentOfType(IndexedChangeHistoryFieldManager.class);
        if (indexedChangeHistoryFieldManager != null) {
            return indexedChangeHistoryFieldManager.getSupportedOperators(this.getIndexField(), this.supportedOperators);
        }
        return this.supportedOperators;
    }

    @Override
    public JiraDataType getDataType() {
        return this.supportedType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleFieldSearchConstants constants = (SimpleFieldSearchConstants)o;
        if (!this.fieldId.equals(constants.fieldId)) {
            return false;
        }
        if (!this.indexField.equals(constants.indexField)) {
            return false;
        }
        if (!this.jqlClauseNames.equals(constants.jqlClauseNames)) {
            return false;
        }
        if (!this.searcherId.equals(constants.searcherId)) {
            return false;
        }
        if (!((Object)this.supportedOperators).equals(constants.supportedOperators)) {
            return false;
        }
        if (!this.supportedType.equals(constants.supportedType)) {
            return false;
        }
        return this.urlParameter.equals(constants.urlParameter);
    }

    public int hashCode() {
        int result = this.indexField.hashCode();
        result = 31 * result + this.jqlClauseNames.hashCode();
        result = 31 * result + this.urlParameter.hashCode();
        result = 31 * result + this.searcherId.hashCode();
        result = 31 * result + this.fieldId.hashCode();
        result = 31 * result + ((Object)this.supportedOperators).hashCode();
        result = 31 * result + this.supportedType.hashCode();
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

